BEM.DOM.decl('owl-carousel', {
    onSetMod: {
        js: {
            inited: function () {
                this._initCarousel();
            }
        }
    },

    _initCarousel: function () {
        var defaultOptions = {
            autoWidth: true,
            dots: false,
            items: 3,
            mouseDrag: false,
            nav: true,
            navText: false,
            pullDrag: false,
            responsive: false,
            touchDrag: BH.lib.global.isTouch,
            rewind: true
        };

        this.$element = this.domElem;
        this.options = $.extend(defaultOptions, this.params.options || {});

        this.$element.owlCarousel(this.options);
        // Чтобы события не всплывали из вложенных каруселей
        this.$element.on('changed.owl.carousel', function (e) {
            e.stopPropagation();
        });
    }
});
