module.exports = function (bh) {
    bh.match('page-content', function (ctx, json) {
        ctx.tag('section');

        if (!json.menu) {
            ctx.content(ctx.content());

            return;
        }

        ctx.content([
            {
                elem: 'menu',
                attrs: { role: 'menu' },
                content: json.menu.map(function (item) {
                    return item;
                })
            },
            {
                elem: 'description',
                content: ctx.content()
            }
        ], true);
    });

    bh.match('page-content__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('page-content__text', function (ctx) {
        var image = ctx.param('image');
        var align = ctx.param('imageAlign');
        var width = ctx.param('imageWidth');
        var text = ctx.param('text');
        var content = [];

        if (image) {
            content.push({
                block: 'image-wrapper',
                content: {
                    block: 'image',
                    attrs: { style: bh.lib.util.sizeStyle(width) },
                    mix: { block: 'products-info', elem: 'image', mods: { align: align } },
                    url: bh.lib.util.mds(image)
                }
            });
        }

        if (text) {
            content.push({
                elem: 'text-wrapper',
                content: bh.lib.util.template(text)
            });
        }

        ctx.content(content);
    });

    bh.match('page-content__subtitle', function (ctx) {
        ctx.tag('h3');
    });

    bh.match('page-content__menu', function (ctx) {
        ctx.tag('ul');
    });

    bh.match('page-content__item', function (ctx) {
        var name = ctx.param('name');
        var current = ctx.param('current');
        var contactPageUrl = ctx.param('contactPageUrl');

        ctx
            .tag('li')
            .content({
                block: 'link',
                mods: { current: current && 'yes', theme: 'normal' },
                content: bh.lib.i18n('menu', name),
                url: [contactPageUrl, name].join('/')
            });
    });
};
