module.exports = function (bh) {
    bh.match('partners-enter', function (ctx) {
        var authUrl = bh.lib.util.passport.getUrl();

        ctx
            .js(true)
            .content([
                {
                    elem: 'enter',
                    content: ctx.param('isAuthorized') ?
                        {
                            block: 'button2',
                            mods: { theme: 'pseudo', size: 'm', type: 'link' },
                            url: ctx.param('addUserUrl'),
                            text: bh.lib.i18n('common', 'addUser')
                        } :
                        {
                            block: 'button2',
                            mods: { theme: 'pseudo', size: 'm', type: 'link' },
                            url: authUrl,
                            text: bh.lib.i18n('common', 'login')
                        }
                }
            ]);
    });
};
