module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('partners-info_page_enter', function (ctx) {
        var data = ctx.param('data');
        var enterMessages = data.messages.partners;
        var isPartner = data.access === 'allowed';
        var isAuthorized = data.userInfo.isAuthorized;
        var role = null;

        if (isAuthorized) {
            role = 'client';
            if (isPartner) {
                role = 'agency';
            }
        } else {
            role = 'empty';
        }

        ctx
            .js(true)
            .content([
                {
                    elem: 'title',
                    content: enterMessages[role].title || data.info.title
                },
                {
                    elem: 'description',
                    content: enterMessages[role].text || data.info.text
                },
                (!isPartner || !isAuthorized) && {
                    elem: 'enter',
                    content: {
                        block: 'partners-enter',
                        isAuthorized: isAuthorized,
                        addUserUrl: data.addUserUrl
                    }
                }
            ]);
    });
};
