module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('partners-info_page_news', function (ctx, json) {
        var data = json.data;
        var posts = data.posts;

        if (!data.blog) {
            ctx.content({
                elem: 'warning',
                content: bh.lib.i18n('common', 'news-is-not-available')
            });

            return;
        }

        var postsCount = posts.length;
        var lastPost = posts[postsCount - 1];

        if (!postsCount) {
            return;
        }

        if (lastPost) {
            ctx.mix({
                block: 'news-loader',
                js: {
                    blockName: 'partners-info',
                    urlNext: lastPost.nextUrl
                }
            });
        }

        ctx.content([
            ctx.content(),
            {
                elem: 'group',
                posts: posts
            },
            lastPost.nextUrl && {
                elem: 'more'
            },
            lastPost.nextUrl && {
                block: 'tooltip',
                mods: { size: 'm', theme: 'error' },
                content: bh.lib.i18n('common', 'more.button.error')
            }
        ], true);
    });

    bh.match('partners-info__more', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: { theme: 'normal', size: 'l', width: 'max' },
            text: bh.lib.i18n('common', 'more.button.text')
        });
    });
};
