module.exports = function (bh) {
    bh.match('partners-info_page_request', function (ctx) {
        /* eslint-disable max-len */
        var data = ctx.param('data');
        var accessIsInvalid = data.role === 'client';

        data.formStructure = {
            step1: {
                fields: data.form.step1
            },
            step2: {
                direct: {
                    goals: {
                        login: {
                            fields: [
                                {
                                    type: 'input',
                                    textarea: true,
                                    placeholder: data.form.step2.direct['login-about'].placeholder,
                                    text: data.form.step2.direct['login-about'].title
                                },
                                {
                                    type: 'input',
                                    placeholder: data.form.step2.direct['login-clients'].placeholder,
                                    text: data.form.step2.direct['login-clients'].title
                                }
                            ]
                        },
                        contract: {
                            fields: data.form.step2.direct.contract.map(function (item) {
                                item.type = 'radiobox';

                                return item;
                            })
                        }
                    }
                },
                market: {
                    goals: {
                        login: {
                            fields: [
                                {
                                    type: 'input',
                                    textarea: true,
                                    placeholder: data.form.step2.market['login-about'].placeholder,
                                    text: data.form.step2.market['login-about'].title
                                },
                                {
                                    type: 'input',
                                    placeholder: data.form.step2.market['login-clients'].placeholder,
                                    text: data.form.step2.market['login-clients'].title
                                }
                            ]
                        },
                        contract: {
                            fields: data.form.step2.market.contract.map(function (item) {
                                item.type = 'radiobox';

                                return item;
                            })
                        }
                    }
                },
                directAndMarket: {
                    goals: {
                        login: {
                            fields: [
                                {
                                    type: 'input',
                                    textarea: true,
                                    placeholder: data.form.step2.directAndMarket['login-about'].placeholder,
                                    text: data.form.step2.directAndMarket['login-about'].title
                                },
                                {
                                    type: 'input',
                                    placeholder: data.form.step2.directAndMarket['login-clients'].placeholder,
                                    text: data.form.step2.directAndMarket['login-clients'].title
                                }
                            ]
                        },
                        contract: {
                            fields: data.form.step2.directAndMarket.contract.map(function (item) {
                                item.type = 'radiobox';

                                return item;
                            })
                        }
                    }
                }
            }
        };

        var isAuthorized = data.userInfo.isAuthorized;
        var requestMessages = data.messages.request;

        ctx.content([
            {
                elem: 'title',
                tag: 'h2',
                content: data.info.title
            },
            isAuthorized ? {
                elem: 'description',
                content: accessIsInvalid ? requestMessages.client.text : data.info.text
            } : {
                elem: 'description',
                content: requestMessages.empty.text
            },
            accessIsInvalid || !isAuthorized ? {
                elem: 'enter',
                content: {
                    block: 'partners-enter',
                    isAuthorized: isAuthorized,
                    addUserUrl: data.addUserUrl
                }
            } : {
                block: 'partners-request',
                requestUrl: data.requestUrl,
                formStructure: data.formStructure
            }
        ]);
    });
};
