module.exports = function (bh) {
    bh.match('partners-info', function (ctx, json) {
        var data = json.data;
        var partnersPage = data.info;

        if (!partnersPage) {
            return;
        }

        ctx.content([
            {
                elem: 'title',
                content: partnersPage.title
            },
            {
                elem: 'text',
                mix: [
                    { block: 'html-content' },
                    { block: 'page-content' }
                ],
                content: [
                    partnersPage.image && {
                        block: 'image',
                        mix: { block: 'partners-info', elem: 'image' },
                        url: bh.lib.util.mds(partnersPage.image)
                    },
                    bh.lib.util.template(partnersPage.text)
                ]
            }
        ]);
    });

    bh.match('partners-info__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('partners-info__description', function (ctx) {
        ctx.mix({
            block: 'html-content'
        });
    });
};
