module.exports = function (bh) {
    /* eslint-disable max-len */

    /**
     * Генерирует поля формы на основе структуры, переданной в data.formStructure
     * @type {{select: getJson.select, input: getJson.input, list: getJson.list, radiobox: getJson.radiobox}}
     */
    var getJson = {
        select: function (opts) {
            return {
                block: 'select',
                mods: {
                    size: 'm',
                    theme: 'normal',
                    'input-type': opts.type,
                    required: opts.required
                },
                content: [
                    opts.text && {
                        elem: 'label',
                        mix: { block: 'partners-request', elem: 'label' },
                        content: opts.text
                    },
                    opts.type && {
                        block: 'tooltip',
                        mods: {
                            size: 'm',
                            theme: 'error',
                            'z-index': 'zero'
                        },
                        mix: {
                            block: 'partners-request',
                            elem: 'tooltip'
                        },
                        js: {
                            offset: -110,
                            to: ['right']
                        },
                        content: opts.validationMessage
                    },
                    {
                        block: 'button',
                        mods: { width: opts.type === 'selectServices' && 'full', theme: 'normal' },
                        content: opts.default || bh.lib.i18n('partners', 'form.emptyValue')
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                elem: 'option',
                                attrs: { value: '' },
                                content: bh.lib.i18n('partners', 'form.emptyValue')
                            },
                            opts.options.map(function (option) {
                                return {
                                    elem: 'option',
                                    attrs: { value: option },
                                    content: opts.type === 'selectServices' ?
                                        bh.lib.i18n('partners', 'form.' + option) : option
                                };
                            })
                        ]
                    }
                ]
            };
        },
        input: function (opts) {
            return {
                block: 'input',
                mods: {
                    size: 'm',
                    required: opts.required ? 'yes' : false,
                    'input-type': opts.type,
                    type: opts.textarea ? 'textarea' : false,
                    theme: 'normal'
                },
                content: [
                    {
                        elem: 'label',
                        mix: { block: 'partners-request', elem: 'label' },
                        content: opts.text
                    },
                    {
                        elem: 'control',
                        attrs: {
                            placeholder: opts.placeholder
                        }
                    },
                    {
                        block: 'tooltip',
                        mods: {
                            size: 'm',
                            theme: 'error',
                            'z-index': 'zero'
                        },
                        mix: {
                            block: 'partners-request',
                            elem: 'tooltip'
                        },
                        js: {
                            offset: -110,
                            to: ['right']
                        },
                        content: opts.validationMessage
                    }
                ]
            };
        },
        list: function (opts) {
            return {
                elem: 'checkbox-list',
                content: [
                    {
                        elem: 'label',
                        mix: { block: 'partners-request', elem: 'label' },
                        mods: { checkboxes: 'yes' },
                        content: opts.text
                    },
                    opts.items.map(function (item) {
                        return {
                            block: 'checkbox',
                            mix: { block: 'partners-request', elem: 'checkbox' },
                            mods: {
                                size: 'm',
                                checked: item.default,
                                theme: 'normal'
                            },
                            checkboxAttrs: {
                                value: item.name
                            },
                            text: {
                                elem: 'label',
                                mix: { block: 'partners-request', elem: 'label' },
                                content: item.text
                            }
                        };
                    })
                ]
            };
        },
        radiobox: function (opts) {
            return {
                block: 'radiobox',
                mods: { size: 'm', theme: 'normal' },
                value: opts.default ? 'yes' : 'no',
                content: [
                    {
                        elem: 'label',
                        mix: { block: 'partners-request', elem: 'label' },
                        content: opts.text
                    },
                    {
                        elem: 'radio',
                        mix: { block: 'partners-request', elem: 'radio' },
                        content: bh.lib.i18n('common', 'yes'),
                        controlAttrs: { value: 'yes' }
                    },
                    {
                        elem: 'radio',
                        mix: { block: 'partners-request', elem: 'radio' },
                        content: bh.lib.i18n('common', 'no'),
                        controlAttrs: { value: 'no' }
                    }
                ]
            };
        }
    };

    bh.match('partners-request', function (ctx) {
        var requestUrl = ctx.param('requestUrl');
        var formStructure = ctx.param('formStructure');

        ctx
            .tag('form')
            .js({
                requestUrl: requestUrl,
                login: bh.lib.global.login
            })
            .content([
                {
                    elem: 'steps',
                    mix: { block: 'clearfix' },
                    content: [
                        {
                            elem: 'step-title',
                            mods: { n: '1', active: 'yes' },
                            content: bh.lib.i18n('partners', 'step1')
                        },
                        {
                            elem: 'step-title',
                            mods: { n: '2' },
                            content: bh.lib.i18n('partners', 'step2')
                        }
                    ]
                },
                {
                    elem: 'step',
                    mods: { n: '1' },
                    data: formStructure.step1
                },
                {
                    elem: 'step',
                    mods: { n: '2', hidden: 'yes' },
                    data: formStructure.step2
                },
                {
                    elem: 'step',
                    mods: { n: '3', hidden: 'yes' }
                },
                {
                    block: 'secret-key-input'
                }
            ]);
    });

    /**
     * Первый шаг. В data.fields только input[type=text].
     */
    bh.match('partners-request__step_n_1', function (ctx) {
        var data = ctx.param('data');

        var fields = data.fields.map(function (field) {
            return {
                elem: 'form-row',
                content: field.type === 'selectServices' ?
                    getJson.select(field) : getJson.input(field)
            };
        });

        ctx.content([
            {
                elem: 'step-wrapper',
                mods: { step: '1' },
                content: fields
            },
            {
                elem: 'buttons',
                step: 1
            },
            {
                elem: 'form-tip'
            }
        ]);
    });

    /**
     * Второй шаг. Создаем селект выбора цели и на каждую цель создаем свой fieldset
     */
    bh.match('partners-request__step_n_2', function (ctx, json) {
        var data = json.data;
        var services = Object.keys(data);

        ctx.content([
            services.map(function (service) {
                var goals = Object.keys(data[service].goals);

                return {
                    elem: 'step-wrapper',
                    mods: { step: '2', service: service, hidden: 'yes' },
                    content: [
                        {
                            elem: 'goals-select',
                            goals: goals,
                            service: service
                        },
                        {
                            elem: 'goal-description',
                            mods: { service: service },
                            content: bh.lib.i18n('partners', 'goal.chooseGoal.text')
                        },
                        goals.map(function (goal) {
                            return {
                                elem: 'fieldset',
                                mods: { goal: goal, service: service, hidden: 'yes' },
                                data: data[service].goals[goal]
                            };
                        })
                    ]
                };
            }),
            {
                elem: 'buttons',
                step: 2
            },
            {
                elem: 'form-tip'
            }
        ]);
    });

    /**
     * Третий шаг. Вывод сообщения об успешной отправке.
     */
    bh.match('partners-request__step_n_3', function (ctx) {
        ctx.content({
            elem: 'step-wrapper',
            mods: { step: '3' },
            content: [
                {
                    elem: 'success-title',
                    tag: 'h2'
                },
                {
                    elem: 'success-text',
                    mix: { block: 'html-content' }
                }
            ]
        });
    });

    /**
     * Селект выбора цели
     */
    bh.match('partners-request__goals-select', function (ctx, json) {
        var goals = json.goals;

        ctx.content([
            {
                block: 'select',
                mods: { size: 'm', theme: 'normal', name: 'goal', service: json.service },
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'normal' },
                        content: bh.lib.i18n('partners', 'goal.chooseGoal')
                    },
                    {
                        elem: 'control',
                        content: [
                            {
                                elem: 'option',
                                attrs: { value: '', selected: 'selected' },
                                content: bh.lib.i18n('partners', 'goal.chooseGoal')
                            },
                            goals.map(function (goal) {
                                return {
                                    elem: 'option',
                                    attrs: { value: goal },
                                    content: bh.lib.i18n('partners', 'goal.' + goal)
                                };
                            })
                        ]
                    }
                ]
            }
        ]);
    });

    /**
     * Наполняем каждый fieldset данными.
     */
    bh.match('partners-request__fieldset', function (ctx, json) {
        var data = json.data;

        if (!data.fields) {
            return '';
        }

        var result = data.fields.map(function (field) {
            return getJson[field.type] ? {
                elem: 'form-row',
                content: getJson[field.type](field)
            } : '';
        });

        ctx.content(result);
    });

    /**
     * Создание блока с кнопками. На 1 шаге - одна кнопка, на 2 шаге - 2 кнопки.
     */
    bh.match('partners-request__buttons', function (ctx) {
        var step = ctx.param('step');
        var content = {
            1: {
                block: 'button2',
                mods: {
                    theme: 'normal',
                    size: 'm',
                    type: 'next'
                },
                text: bh.lib.i18n('partners', 'button.next')
            },
            2: [
                {
                    elem: 'left-button',
                    content: {
                        block: 'button2',
                        mods: {
                            theme: 'normal',
                            size: 'm',
                            type: 'back'
                        },
                        text: bh.lib.i18n('partners', 'button.back')
                    }
                },
                {
                    elem: 'error',
                    content: bh.lib.i18n('forms', 'error.server')
                },
                {
                    block: 'spin2',
                    mods: { size: 'm' }
                },
                {
                    block: 'button2',
                    mods: {
                        theme: 'action',
                        disabled: 'yes',
                        size: 'm',
                        type: 'send'
                    },
                    text: bh.lib.i18n('partners', 'button.send')
                }
            ]
        };

        ctx
            .mix({ block: 'clearfix' })
            .content(content[step]);
    });

    /**
     * Подсказка серым шрифтом под формой
     */
    bh.match('partners-request__form-tip', function (ctx) {
        ctx.content(bh.lib.i18n('partners', 'form.tip'));
    });
};
