BEM.DOM.decl('partners-request', {
    onSetMod: {
        js: {
            inited: function () {
                this._currentStep = '1';
                this._requestUrl = this.params.requestUrl;
                this._formData = {};
                this._sk = this.findBlockInside('secret-key-input').domElem.val();
                this._services = ['direct', 'market', 'directAndMarket'];

                this.findElems();
                this.bindEvents();
                this._placeErrorTooltips();
            }
        }
    },

    findElems: function () {
        this._firstStepInputs = this.findBlocksInside(this.elem('step', 'n', '1'), 'input');
        this._selectServices = this.findBlockInside({
            block: 'select',
            modName: 'input-type',
            modVal: 'selectServices'
        });

        this._firstStepInputs.push(this._selectServices);

        this._secondStepInputs = $.merge(
            this.findBlocksInside(this.elem('step', 'n', '2'), {
                block: 'select',
                modName: 'required',
                modVal: 'yes'
            }),

            this.findBlocksInside(this.elem('step', 'n', '2'), {
                block: 'input',
                modName: 'required',
                modVal: 'yes'
            })
        );

        this._backBtn = this.findBlockInside({ block: 'button2', modName: 'type', modVal: 'back' });
        this._nextBtn = this.findBlockInside({ block: 'button2', modName: 'type', modVal: 'next' });
        this._sendBtn = this.findBlockInside({ block: 'button2', modName: 'type', modVal: 'send' });
        this._spinner = this.findBlockInside('spin2');

        this._goalSelects = this.findBlocksInside({
            block: 'select',
            modName: 'name',
            modVal: 'goal'
        });
    },

    bindEvents: function () {
        this._nextBtn.on('click', this._onNextClick.bind(this));
        this._backBtn.on('click', this._onBackClick.bind(this));
        this._sendBtn.on('click', this._onSendClick.bind(this));

        this._goalSelects.forEach(function (select) {
            select.on('change', this._onGoalChange.bind(this));
        }.bind(this));
        this._firstStepInputs.forEach(function (block) {
            block.on('change', this._removeInputTooltip.bind(this, block));
        }.bind(this));
        this._secondStepInputs.forEach(function (block) {
            block.on('change', this._validateSecondStep.bind(this));
        }.bind(this));
    },

    /**
     * Переход между шагами формы
     * @param {String} step - Шаг, на который переключаемся
     * @private
     */
    _changeStep: function (step) {
        this.setMod(this.elem('step', 'n', this._currentStep), 'hidden', 'yes');
        this.delMod(this.elem('step-title', 'n', this._currentStep), 'active');

        this._currentStep = step;

        this.delMod(this.elem('step', 'n', this._currentStep), 'hidden');
        this.setMod(this.elem('step-title', 'n', this._currentStep), 'active', 'yes');
        this.delMod(this.elem('step-wrapper', 'service', this._choosenService), 'hidden');

        BEM.blocks['scroll-to'].scrollTo(this, { offsetTop: 60 });
    },

    /**
     * Клик на кнопку "Далее" на первом шаге
     * @private
     */
    _onNextClick: function () {
        if (this._validateFirstStep()) {
            this._formData.step1 = this._firstStepInputs.map(this._getInputData.bind(this));
            this._formData.step1.push({
                label: BH.lib.i18n('forms', 'label.login'),
                value: this.params.login || '–'
            });
            this._choosenService = this._selectServices.val();

            this.elem('goal-description', 'service', this._choosenService)
                .html(BH.lib.i18n('partners', 'goal.chooseGoal.text'));

            this._changeStep('2');
        }
    },

    /**
     * Клик на кнопку "Назад" на втором шаге
     * @private
     */
    _onBackClick: function () {
        this._changeStep('1');
        this.setMod(this.elem('step-wrapper', 'service', this._choosenService), 'hidden', 'yes');
        this._goalSelects.forEach(function (select) {
            select.val('');
        });
    },

    /**
     * Клик на кнопку "Отправить заявку" на втором шаге
     * @private
     */
    _onSendClick: function () {
        var formData = this._buildFormData();

        // Убираем серверную ошибку слева от кнопки отправки
        this.delMod(this.elem('error'), 'visible');

        // Дисэйблим все поля и кнопку, показываем спиннер
        this._setFormProcessing();

        var currentSelect = this._getCurrentGoalSelect();

        $.ajax({
            type: 'POST',
            url: this._requestUrl,
            headers: {
                'x-csrf-token': this._sk
            },
            contentType: 'application/json',
            data: JSON.stringify(formData)
        })
            .done(this._showSuccessMessage.bind(this, currentSelect.val()))
            .fail(this._showErrorMessage.bind(this))
            .always(this._removeFormProcessing.bind(this));
    },

    /**
     * Находит текущий селект цели
     * @returns {jquery}
     * @private
     */
    _getCurrentGoalSelect: function () {
        return this._goalSelects.filter(function (select) {
            return select.getMod('service') === this._choosenService;
        }.bind(this))[0];
    },

    /**
     * При успешной отправке формы, показываем текст. Для каждой из целей - свой текст.
     * @param {String} goal
     * @private
     */
    _showSuccessMessage: function (goal) {
        this.elem('success-title').text(BH.lib.i18n('partners', 'form.ty.title'));
        this.elem('success-text').html(BH.lib.i18n('partners', 'form.ty.' + goal));

        BEM.blocks.metrika.reachGoal('form_partners_request');

        this._changeStep('3');
        this._removeSteps();
    },

    /**
     * Если при отправке формы сервер ответил ошибкой, то показываем ошибку слева от кнопки отправки
     * @private
     */
    _showErrorMessage: function () {
        this.setMod(this.elem('error'), 'visible', 'yes');
    },

    /**
     * Валидация полей на первом шаге
     * Все поля - required, проверяем что они заполнены.
     * @private
     * @returns {Boolean}
     */
    _validateFirstStep: function () {
        var isValid = true;

        var inputTypeToValidationFunction = {
            text: this._validateText.bind(this),
            email: this._validateEmail.bind(this),
            phone: this._validatePhoneNumber.bind(this),
            selectServices: this._validateText.bind(this),
            login: this._validateLogin.bind(this)
        };

        this._firstStepInputs.forEach(function (input) {
            var val = $.trim(input.val());
            var type = input.getMod('input-type');
            var validationFunction = inputTypeToValidationFunction[type];

            this._removeInputTooltip(input);

            if (validationFunction && !validationFunction(val)) {
                isValid = false;
                input.tooltip.setMod('shown', 'yes');
            }
        }.bind(this));

        return isValid;
    },

    /**
     * Валидация текстового поля
     * @param {String} val
     * @returns {Boolean}
     * @private
     */
    _validateText: function (val) {
        return Boolean(val.length);
    },

    /**
     * Валидация email
     * Поле email проверяем на наличие собаки и точки.
     * @param {String} val
     * @returns {boolean}
     * @private
     */
    _validateEmail: function (val) {
        return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(val);
    },

    /**
     * Валидация телефонного номера
     *
     * Регулярное выражение для валидации телефонного номера.
     * Номер телефона состоит из трёх частей: код страны/оператора, код города, хвост.
     * Код страны/оператора может содержать от 1 до 3 цифр. Может начинаться с плюса.
     * Код города может содержать от 1 до 3 цифр. Может быть взят в скобки.
     * Части номера могут быть разделены пробелами или дефисами.
     * @param {String} val
     * @returns {Boolean}
     * @private
     */
    _validatePhoneNumber: function (val) {
        return /^((\+?\d{1,3})[- ]?)?(\(?\d{1,3}\)?[- ]?)?[\d\- ]{7,10}$/.test(val);
    },

    /**
     * Валидация логина главного представления
     * @param {String} val
     * @returns {Boolean}
     * @private
     */
    _validateLogin: function (val) {
        return /^[A-Za-z0-9-_.]+$/.test(val);
    },

    /**
     * Убирает красный тултип-ошибку с инпута
     * @param {Object|Block} input
     * @private
     */
    _removeInputTooltip: function (input) {
        input.tooltip.delMod('shown');
    },

    /**
     * Получает все инпуты на втором шаге
     * @returns {Object}
     * @private
     */
    _getSecondStepInputs: function () {
        var wrapper = this.elem('step-wrapper', 'service', this._choosenService);

        return $.merge(
            this.findBlocksInside(wrapper, { block: 'select', modName: 'required', modVal: 'yes' }),
            this.findBlocksInside(wrapper, { block: 'input', modName: 'required', modVal: 'yes' })
        );
    },

    /**
     * Валидация полей на втором шаге
     * @private
     */
    _validateSecondStep: function () {
        var goal = this._getCurrentGoalSelect().val();
        var buttonIsEnabled = true;

        if (!goal) {
            buttonIsEnabled = false;
        }

        if (buttonIsEnabled) {
            this._sendBtn.delMod('disabled');
        } else {
            this._sendBtn.setMod('disabled', 'yes');
        }
    },

    /**
     * Отслеживаем изменение значения селекта
     * @private
     */
    _onGoalChange: function () {
        var choosenService = this._choosenService;
        var goal = this._getCurrentGoalSelect().val() || 'chooseGoal';
        var service = goal ? '.' + choosenService : '';
        var descriptionElem = this.elem('goal-description', 'service', choosenService);

        this._showFieldset(goal);
        this._validateSecondStep();
        descriptionElem.html(BH.lib.i18n('partners', 'goal.' + goal + service + '.text'));
    },

    /**
     * Переключаем видимые поля на втором шаге, в зависимости от значения селекта
     * @param {String} goal
     * @private
     */
    _showFieldset: function (goal) {
        this.elem('fieldset', 'service', this._choosenService).each(function (i, elem) {
            var $elem = $(elem);

            if (this.getMod($elem, 'goal') === goal) {
                this.delMod($elem, 'hidden');
            } else {
                this.setMod($elem, 'hidden', 'yes');
            }
        }.bind(this));
    },

    /**
     * После удачной отправки формы удаляем из DOM первый и второй шаги
     * @private
     */
    _removeSteps: function () {
        this.elem('steps').remove();
        this.elem('step', 'n', '1').remove();
        this.elem('step', 'n', '2').remove();
    },

    _setFormProcessing: function () {
        this._spinner.setMod('progress', 'yes');
        this._backBtn.setMod('disabled', 'yes');
        this._sendBtn.setMod('disabled', 'yes');
    },

    _removeFormProcessing: function () {
        this._spinner.delMod('progress');
        this._backBtn.delMod('disabled');
        this._sendBtn.delMod('disabled');
    },

    /**
     * Размещаем у каждого из полей красные тултипы-подсказки
     * @private
     */
    _placeErrorTooltips: function () {
        this._firstStepInputs.forEach(function (input) {
            var tooltip = input.findBlockInside('tooltip');
            var type = input.getMod('input-type');
            var owner = type === 'selectServices' ?
                this.findBlockInside(input.domElem, 'button').domElem : input.elem('box');

            input.tooltip = tooltip;
            tooltip.setOwner(owner);
        }.bind(this));
    },

    /**
     * Принимает блок (input/select/radiobox) и возвращает текст его лэйбла и его значение
     * @param {Object|Block} block
     * @returns {{label: String, value: String}}
     * @private
     */
    _getInputData: function (block) {
        return {
            label: block.elem('label').text(),
            value: this._humanizeServiceName(block.val())
        };
    },

    /**
     * Возвращает название сервиса
     * @param {String} val
     * @returns {String}
     * @private
     */
    _humanizeServiceName: function (val) {
        if (this._services.indexOf(val) > -1) {
            return BH.lib.i18n('partners', 'form.' + val);
        }

        return val;
    },

    /**
     * Добавляет в this._formData данные о втором шаге формы, в зависимости от выбранной цели
     * @returns {Object}
     * @private
     */
    _buildFormData: function () {
        var serviceName = BH.lib.i18n('partners', 'form.' + this._choosenService);
        var serviceValue = serviceName ? ' (' + serviceName + ')' : '';

        var wrapper = this.elem('step-wrapper', 'service', this._choosenService);

        var goal = this._getCurrentGoalSelect().val();
        var goalName = BH.lib.i18n('partners', 'goal.' + goal);
        var goalValue = goalName ? goalName + serviceValue : '';

        this._formData = $.extend(this._formData, {
            choosenService: this._choosenService,
            goal: goal,
            step2: [
                {
                    label: '',
                    value: goalValue
                }
            ]
        });

        this._buildDataByGoal(goal, wrapper);

        return this._formData;
    },

    /**
     * Формирование данных по цели
     * @param {String} goal
     * @param {jquery} wrapper
     * @private
     */
    _buildDataByGoal: function (goal, wrapper) {
        if (goal === 'login') {
            var fieldset = this.findElem(wrapper, 'fieldset', 'goal', 'login');

            this.findBlocksInside(fieldset, 'input').forEach(function (block) {
                this._formData.step2.push(this._getInputData(block));
            }.bind(this));
        } else if (goal === 'contract') {
            this._formData.step2 = this._getContractBlocks(wrapper);
        }
    },

    /**
     * Формирует данные для договора
     * @param {jquery} wrapper
     * @returns {Array}
     * @private
     */
    _getContractBlocks: function (wrapper) {
        return this.findBlocksInside(wrapper, 'radiobox')
            .map(function (block) {
                return {
                    label: block.elem('label').text(),
                    value: BH.lib.i18n('common', block.val())
                };
            });
    }
});
