module.exports = function (bh) {
    bh.match('pie-chart', function (ctx) {
        var value = parseFloat(ctx.param('value'));
        var angle = (1 - value / 50) * 180;

        ctx
            .mods({ 'more-half': value > 50 && 'yes' })
            .content({
                elem: 'wrapper',
                content: {
                    elem: 'line',
                    angle: angle
                }
            });
    });

    bh.match('pie-chart__line', function (ctx) {
        var angle = ctx.param('angle').toFixed(2);
        var transformRotate = 'transform: rotate(' + angle + 'deg);';

        /* eslint-disable max-len */
        ctx.attr('style', ' -ms-' + transformRotate + ' -webkit-' + transformRotate + transformRotate);
    });
};
