module.exports = function (bh) {
    bh.match('poster', function (ctx, json) {
        var data = json.data;
        var queryParams = json.queryParams || {};
        var modal = data.modal || {};
        var tabs = modal.tabs || [];

        var activeTab = getActiveTab(tabs, queryParams);
        var modalOpened = queryParams.modal === '1';

        ctx
            .js({
                goals: data.goals,
                carouselElemsCount: (data.items || []).length,
                activeTab: activeTab,
                modalOpened: modalOpened,
                saveModalTab: false,
                ctaType: (data.cta || {}).url ? 'link' : 'action'
            })
            .tag('article')
            .content([
                {
                    elem: 'header',
                    data: {
                        title: data.title,
                        slogan: data.caption,
                        desc: data.text
                    }
                },
                data.items && {
                    elem: 'main',
                    data: {
                        activeTab: activeTab,
                        items: data.items,
                        cta: data.cta,
                        requirements: data.requirements
                    }
                },
                (data.footer || {}).cta && {
                    elem: 'footer',
                    data: {
                        text: data.footer.text,
                        cta: data.footer.cta,
                        url: data.cta.url,
                        new: data.cta.new
                    }
                },
                {
                    block: 'modal',
                    mods: {
                        theme: 'normal',
                        autoclosable: 'yes',
                        type: 'dark',
                        size: 'xl'
                    },
                    content: {
                        block: 'poster',
                        elem: 'modal',
                        tabs: tabs,
                        activeTab: activeTab
                    }
                }
            ]);
    });

    bh.match('poster__footer', function (ctx, json) {
        var data = json.data;

        ctx
            .mods({ theme: 'normal' })
            .content({
                elem: 'footer-content',
                content: [
                    {
                        elem: 'footer-cta',
                        content: {
                            block: 'button2',
                            mods: {
                                size: 'm',
                                theme: 'action',
                                type: data.url ? 'link' : 'action'
                            },
                            content: {
                                elem: 'text', content: [
                                    data.cta,
                                    {
                                        block: 'icon',
                                        mods: { glyph: 'type-more' },
                                        mix: { block: 'button2', elem: 'icon' }
                                    }
                                ]
                            },
                            url: data.url,
                            target: data.new ? 'blank' : 'self'
                        }

                    },
                    {
                        elem: 'footer-text',
                        content: data.text
                    }
                ]
            });
    });

    bh.match('poster__modal', function (ctx, json) {
        var tabs = json.tabs;
        var activeTab = json.activeTab;
        var needSelect = tabs.length > 1;

        ctx
            .content([
                needSelect && {
                    block: 'tabs-select',
                    tabs: tabs.map(function (tab) {
                        return tab.name;
                    }),
                    activeTab: activeTab,
                    mix: { block: 'poster', elem: 'modal-select' },
                    theme: 'light-dark',
                    panes: 'menu-tabs'
                },
                {
                    block: 'tabs-panes',
                    mix: { block: 'poster', elem: 'modal-panes' },
                    id: 'menu-tabs',
                    content: tabs.map(buildModalTab(activeTab, !needSelect))
                }
            ]);
    });

    bh.match('poster__header', function (ctx, json) {
        var data = json.data;

        ctx
            .tag('header')
            .content([
                {
                    elem: 'title',
                    tag: 'span',
                    content: data.title
                },
                {
                    elem: 'slogan',
                    tag: 'h1',
                    content: data.slogan
                },
                {
                    elem: 'description',
                    tag: 'span',
                    content: data.desc
                }
            ]);
    });

    bh.match('poster__main', function (ctx, json) {
        var views = json.data.items || [];

        views = filterViews(views, bh.lib.global.isMobile);
        views = rearrangeViews(views, bh.lib.global.isMobile);

        var cta = json.data.cta;
        var requirements = json.data.requirements;

        var options = views.map(function(view) {
            return view.name;
        });

        ctx
            .tag('main')
            .content([
                (options.length > 1) && {
                    elem: 'control',
                    content: [
                        {
                            block: 'horizontal-select',
                            mods: { theme: 'dark' },
                            data: {
                                items: options
                            }
                        }
                    ]
                },
                {
                    elem: 'carousel-wrapper',
                    items: views.map(function (view, viewIndex) {
                        var isActive = viewIndex === json.data.activeTab;

                        return buildView(view, viewIndex, isActive);
                    })
                },
                cta.text && {
                    elem: 'cta',
                    content: {
                        block: 'button2',
                        mods: {
                            size: 'm',
                            theme: 'action',
                            type: cta.url ? 'link' : 'action'
                        },
                        text: cta.text,
                        url: cta.url,
                        target: cta.new ? 'blank' : 'self'
                    }
                },
                requirements.title && {
                    elem: 'requirements',
                    requirements: requirements
                }
            ]);
    });

    bh.match('poster__requirements', function (ctx, json) {
        var requirements = json.requirements;

        ctx
            .content([
                {
                    elem: 'requirements-link',
                    tag: 'a',
                    content: requirements.title,
                    attrs: {
                        href: requirements.link,
                        target: requirements.new ? '_blank' : '_self'
                    }
                }
            ]);
    });

    function getActiveTab(tabs, params) {
        var maxIndex = tabs.length - 1;

        var activeTab = 0;
        var paramsTab = Number(params.tab);

        if (isFinite(paramsTab)) {
            activeTab = Math.max(Math.min(paramsTab, maxIndex), 0);
        }

        return activeTab;
    }

    function buildModalTab(activeTab, needTopOffset) {
        return function(tab, index) {
            var mods = index === activeTab ? { active: 'yes' } : null;

            return {
                elem: 'pane',
                mix: { block: 'poster', elem: 'modal-pane' },
                elemMods: mods,

                content: {
                    block: 'poster',

                    elem: 'modal-tab-main',
                    content: [
                        {
                            block: 'poster',
                            elem: 'modal-tab-header',
                            mods: { 'from-top': needTopOffset },
                            content: [
                                {
                                    elem: 'modal-tab-title',
                                    content: tab.title
                                },
                                {
                                    elem: 'modal-tab-description',
                                    content: tab.description
                                }
                            ]
                        },
                        buildModalTabContent(tab, index)
                    ]
                }
            };
        };
    }

    function buildModalTabContent(tab, index) {
        if (tab.type === 'form') {
            var formData = tab.form || {};

            if (!formData.url) {
            }

            var formName = 'adv-ad-product_' + index;

            return {
                elem: 'order-form',
                content: {
                    block: 'adaptive-form',
                    data: {
                        attrs: {
                            name: formName,
                            height: '550px'
                        },
                        url: formData.url,
                        theme: formData.theme,
                        params: {
                            adaptive: true,
                            name: formName,
                            goal: formData.goal
                        }
                    }
                }
            };
        } else if (tab.type === 'chat') {
            return {
                elem: 'chat',
                content: {
                    block: 'chat-imitation',
                    data: tab.chat
                }
            };
        }

        return null;
    }

    function filterViews(views, isMobile) {
        var filterField = isMobile ? 'mobileOrder' : 'desktopOrder';

        return views.filter(function(view) {
            return view[filterField] >= 0;
        });
    }

    function rearrangeViews(views, isMobile) {
        var sortField = isMobile ? 'mobileOrder' : 'desktopOrder';
        var sortFunction = function(view1, view2) {
            return view1[sortField] - view2[sortField];
        };

        return views.sort(sortFunction);
    }

    function buildView(view, viewIndex, isActive) {
        return {
            block: 'poster',
            elem: 'view',
            attrs: {
                'data-view-index': viewIndex
            },
            mods: { type: view.viewType },
            content: [
                !isActive && {
                    block: 'spin2',
                    mods: {
                        size: 'm',
                        progress: 'yes'
                    },
                    mix: {
                        block: 'poster',
                        elem: 'view-spin'
                    }
                },
                buildItems(view.items, view.viewType, isActive)
            ]
        };
    }

    function buildItems(items, viewType, isActive) {
        // На десктопе можно показать 2 мобильных элемента
        var maxItemsCount = (viewType === 'mobile' && !bh.lib.global.isMobile) ? 2 : 1;

        var content = items
            .slice(0, maxItemsCount)
            .map(function(item) {
                switch (item.type) {
                    case 'gif':
                    case 'image':
                        return {
                            tag: 'img',
                            attrs: {
                                'data-src': item.link,
                                src: isActive && item.link,
                                alt: ''
                            },
                            content: item,
                            mix: {
                                block: 'poster',
                                elem: 'item',
                                mods: { type: item.type }
                            }
                        };
                    case 'video':
                        return {
                            block: 'poster',
                            elem: 'item',
                            mods: { type: item.type },
                            content: [
                                {
                                    tag: 'iframe',
                                    attrs: {
                                        width: '100%',
                                        height: '100%',
                                        frameborder: 0,
                                        allowfullscreen: true,
                                        allow: 'autoplay',
                                        'data-src': item.link,
                                        'data-aspect-ratio': parseFloat(item.aspectRatio) || -1,
                                        src: isActive && item.link
                                    }
                                },
                                {
                                    elem: 'swipe-zone',
                                    mods: { position: 'left' }
                                },
                                {
                                    elem: 'swipe-zone',
                                    mods: { position: 'right' }
                                }
                            ]
                        };
                    default:
                        return;
                }
            });

        return content;
    }
};
