BEM.DOM.decl('poster', {
    onSetMod: {
        js: {
            inited: function () {
                this._goals = this.params.goals || {};
                this._scrollDebounceDelay = 300;
                this._scrollFooterDebounceDelay = 50;
                this._isArtificialEvent = false;
                this._detectScroll = BEM.blocks['i-bem'].detectScrollEnd.bind(this);

                this._extractParams();

                this._findElems();
                this._addEventHandlers();

                this._setViewAspectRatio(this.params.activeTab);

                if (this._modalOpened && this._ctaType === 'action') {
                    this._showModal();
                }
            }
        }
    },

    _extractParams: function() {
        this._modalOpened = this.params.modalOpened;
        this._ctaType = this.params.ctaType;
        this._currentModalTab = this.params.activeTab;
        this._shouldSaveModalTab = this.params.saveModalTab;
        this._carouselElemsCount = this.params.carouselElemsCount;
    },

    _findElems: function() {
        this._cta = this.elem('cta');
        this._link = this.elem('requirements');
        this._footer = this.elem('footer');
        this._footerCta = this.elem('footer-cta');
        this._select = this.findBlockInside({ block: 'horizontal-select' });
        this._carousel = this.findBlockInside({ block: 'owl-carousel' }).$element;
        this._carouselData = this._carousel.data('owl.carousel');
        this._carouselItems = this.findElem('item');

        this._modal = this.findBlockInside({ block: 'modal' });
        this._modalTabsSelector = this.findBlockInside({ block: 'tabs-select' });
    },

    _addEventHandlers: function() {
        this.bindTo(this._cta, 'pointerclick', this._onButtonClick.bind(this));

        this._addCarouselHandlers();
        this._addModalHandlers();

        this._addMetrikaHandlers();
        this._addFooterHandlers();
    },

    _addModalHandlers: function() {
        if (this._modalTabsSelector && this._shouldSaveModalTab) {
            this._modalTabsSelector.on('change', function(event, data) {
                this._currentModalTab = data.currentIndex;
                this._updateUrl();
            }, this);
        }

        if (this._modal) {
            this._modal.on('afterOpen', function() {
                this._modalOpened = true;
                this._updateUrl();
            }, this);

            this._modal.on('afterClose', function() {
                this._modalOpened = false;
                this._updateUrl();
            }, this);
        }
    },

    _addCarouselHandlers: function() {
        if (this._carousel) {
            this._carousel.on('changed.owl.carousel', this._onCarouselItemChanged.bind(this));
        }

        if (this._carouselElemsCount > 1 && this._select) {
            this._select.onSelectChanged(this._onSelectItemChanged.bind(this));
        }

        for (var i = 0; i < this._carouselItems.length; i += 1) {
            var item = this._carouselItems[i];

            $(item).on('load', this._refreshCarousel.bind(this));
        }

    },

    _updateUrl: function() {
        var query = [];

        if (this._modalOpened) {
            query.push('modal=1');
        }

        if (typeof this._currentModalTab !== 'undefined' && this._shouldSaveModalTab) {
            query.push('tab=' + this._currentModalTab);
        }

        var url = window.location.origin + window.location.pathname;

        if (query.length > 0) {
            url += '?' + query.join('&');
        }

        BEM.blocks['i-bem'].replaceUrl({}, 'product', url);
    },

    _addFooterHandlers: function() {
        if (!this._footer.length) {
            return;
        }

        this.bindTo(this._footerCta, 'pointerclick', this._onFooterButtonClick.bind(this));

        this._updateFooterStateHandler = $.debounce(
            this._updateFooterState.bind(this),
            this._scrollFooterDebounceDelay
        );
        this.bindToWin('scroll', this._updateFooterStateHandler);
    },

    _refreshCarousel: function() {
        if (this._carouselData) {
            this._carouselData.refresh();
        }
    },

    _updateFooterState: function() {
        var menuHeight = 60;
        var ctaOnScreen = BEM.blocks['i-bem'].checkOnScreen(this._cta, 'top', menuHeight);
        var theme = ctaOnScreen ? 'normal' : 'dark';

        this.setMod(this._footer, 'theme', theme);
    },

    _addMetrikaHandlers: function() {
        if (this._goals.content) {
            this._scrollToCarouselHandler = $.debounce(
                this._detectScrollToCarousel.bind(this),
                this._scrollDebounceDelay
            );

            this.bindToWin('scroll', this._scrollToCarouselHandler);
        }

        if (this._goals.showButton && this._cta.length > 0) {
            this._scrollToButtonHandler = $.debounce(
                this._detectScrollToButton.bind(this),
                this._scrollDebounceDelay
            );

            this.bindToWin('scroll', this._scrollToButtonHandler);
        }

        if (this._goals.techRequirements) {
            this.bindTo(
                this._link,
                'pointerclick',
                this._clickReachGoal.bind(this, this._goals.techRequirements)
            );
        }
    },

    _onFooterButtonClick: function() {
        this._onCtaClick(this._goals.clickFooterButton);
    },

    _onButtonClick: function() {
        this._onCtaClick(this._goals.clickButton);
    },

    _onCtaClick: function(goal) {
        if (goal) {
            this._clickReachGoal(goal);
        }

        if (this._ctaType === 'action') {
            this._showModal();
        }
    },

    _clickReachGoal: function(goal) {
        BEM.blocks.metrika.reachGoal(goal);
    },

    _detectScrollToCarousel: function () {
        this._detectScroll(
            this._carousel,
            this._goals.content,
            this._scrollToCarouselHandler,
            0.8
        );
    },

    _detectScrollToButton: function () {
        this._detectScroll(
            this._cta,
            this._goals.showButton,
            this._scrollToButtonHandler,
            0.8
        );
    },

    _onCarouselItemChanged: function(event) {
        if (this._goals.tabs) {
            BEM.blocks.metrika.reachGoal(this._goals.tabs);
        }

        var index = this._carouselData.relative(event.item.index);

        this._initView(index);

        if (this._isArtificialEvent) {
            return;
        }

        this._select.selectByIndex(index, false);
    },

    _onSelectItemChanged: function(event) {
        // Вызов метода to синхроно тригерит событие
        // Которое приводит к вызову метода _onCarouselItemChanged
        // Для предотвращения этого выставляем _isArtificialEvent в true
        this._isArtificialEvent = true;

        this._carouselData.to(event.item.index);

        this._isArtificialEvent = false;
    },

    _initView: function(index) {
        var self = this;

        var $view = this.domElem.find('[data-view-index=' + index + ']');
        var $spin = $view.find('.spin2');

        var $deferred = $.Deferred(); // eslint-disable-line new-cap
        var loadingCount = 0;

        function handleLoad() {
            loadingCount -= 1;

            if (!loadingCount) {
                $deferred.resolve();
            }
        }

        // Лениво загружаем iframe и картинки
        $('[data-view-index=' + index + '] [data-src]').each(function (_, item) {
            loadingCount += 1;

            if (!item.src) {
                item.onload = handleLoad;
                item.src = item.dataset.src;

                self._setViewAspectRatio(index);
            }
        });

        $deferred.done(function () {
            $spin.remove();
        });
    },

    _setViewAspectRatio: function(index) {
        var carouselWidth = this._carousel.width();
        var carouselHeight = this._carousel.height();

        $('[data-view-index=' + index + '] iframe[data-src]').each(function (_, item) {
            var aspectRatio = parseFloat(item.dataset.aspectRatio);

            if (aspectRatio === -1) {
                return;
            }

            var newWidth = item.width;
            var newHeight = item.height;

            if (aspectRatio < 1) {
                newWidth = Math.min(carouselWidth, Math.ceil(item.offsetHeight * aspectRatio));
                newHeight = Math.ceil(newWidth / aspectRatio);
            } else {
                newHeight = Math.min(carouselHeight, Math.ceil(item.offsetWidth / aspectRatio));
                newWidth = Math.ceil(newHeight * aspectRatio);
            }

            item.width = newWidth;
            item.height = newHeight;
        });
    },

    _showModal: function () {
        if (this._modal) {
            this._modal.setMod('visible', 'yes');
        }
    }
});
