function mapItems(item) {
    return {
        elem: 'item',
        url: item.url,
        name: item.name
    };
}

function splitIntoTwoColumns(arr) {
    var half = Math.ceil(arr.length / 2);

    return [
        arr.slice(0, half)
            .map(mapItems),
        arr.slice(half)
            .map(mapItems)
    ];
}

module.exports = function (bh) {
    bh.match('prefooter', function (ctx) {
        ctx.tag('section');
    });

    bh.match('prefooter__data', function (ctx) {
        var data = ctx.param('data');

        ctx.content([
            data.prefooter.map(function (section) {
                var column = {
                    elem: 'column',
                    title: section.title
                };

                if (section.twoColumns) {
                    column.content = splitIntoTwoColumns(section.items)
                        .map(function (col) {
                            return {
                                elem: 'col',
                                content: col
                            };
                        });
                } else {
                    column.content = section.items.map(mapItems);
                }

                return column;
            })
        ]);
    });

    bh.match('prefooter__item', function (ctx) {
        ctx.content({
            block: 'link',
            mods: {
                theme: 'black'
            },
            content: ctx.content(),
            text: ctx.param('name'),
            url: ctx.param('url')
        }, true);
    });

    bh.match('link', function (ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'))
            .content(ctx.param('name'));
    });
};
