module.exports = function (bh) {
    function getProductInfo (product, type) {
        return {
            elem: 'product',
            content: [
                {
                    elem: 'header',
                    mix: { block: 'clearfix' },
                    content: [
                        product.abovetitle && {
                            elem: 'product-abovetitle',
                            tag: 'h3',
                            content: product.abovetitle
                        },
                        {
                            elem: 'product-title',
                            tag: 'h2',
                            content: product.title
                        },
                        type === 'tables' && {
                            elem: 'product-link',
                            url: product.url
                        }
                    ]
                },
                product[type].map(function (table) {
                    return {
                        block: 'product-price',
                        hideSectionTitle: true,
                        hideTableLink: true,
                        hideCommonInfo: type === 'prices',
                        spreadInfo: type === 'prices',
                        data: table
                    };
                })
            ]
        };
    }

    function getFooter (block, hasBottomOffset) {
        return block.footer && {
            elem: 'text',
            mods: {
                top: true,
                bottom: hasBottomOffset
            },
            content: block.footer
        };
    }

    bh.match('prices-info_type_common', function (ctx) {
        var data = ctx.param('data');

        ctx.content([
            data.products.title && {
                elem: 'title',
                content: data.products.title
            },
            data.products.text && {
                elem: 'text',
                mods: { bottom: true },
                content: data.products.text
            },
            data.products.data.map(function (block, index) {
                return [
                    block.list.reduce(function (result, product) {
                        if (!product.tables.length) {
                            return result;
                        }

                        result.push(getProductInfo(product, 'tables'));

                        return result;
                    }, []),
                    getFooter(block, index < data.products.data.length - 1)
                ];
            })
        ]);
    });

    bh.match('prices-info_type_list', function (ctx) {
        var data = ctx.param('data');

        ctx.content([
            data.products.title && {
                elem: 'title',
                content: data.products.title
            },
            data.products.text && {
                elem: 'text',
                mods: { bottom: true },
                content: data.products.text
            },
            data.products.data.map(function (block, index) {
                return [
                    block.list.reduce(function (result, product) {
                        if (!product.prices.length) {
                            return result;
                        }

                        result.push(getProductInfo(product, 'prices'));

                        return result;
                    }, []),
                    getFooter(block, index < data.products.data.length - 1)
                ];
            })
        ]);
    });

    bh.match('prices-info__text', function (ctx) {
        ctx.mix({ block: 'html-content' });
    });

    bh.match('prices-info__product-link', function (ctx) {
        ctx.content({
            block: 'link',
            mods: { theme: 'normal' },
            url: ctx.param('url'),
            text: bh.lib.i18n('products', 'terms')
        });
    });
};
