module.exports = function (bh) {
    bh.match('product-chart-bars', function (ctx, json) {
        var data = json.data;

        ctx
            .tParam('hasToggle', data.chart.data.length > 1)
            .js({ data: data.chart.data })
            .content([
                {
                    elem: 'title',
                    content: data.title
                },
                {
                    mix: { block: 'html-content' },
                    content: [
                        {
                            elem: 'chart-wrapper',
                            content: [
                                {
                                    elem: 'chart-name',
                                    content: data.chart.name
                                },
                                {
                                    elem: 'chart-toggle',
                                    data: data.chart.data
                                },
                                {
                                    elem: 'chart',
                                    content: {
                                        block: 'chart2',
                                        js: {
                                            chart: {
                                                data: [data.chart.data[0]]
                                            }
                                        },
                                        mods: { type: 'bars' }
                                    }
                                },
                                {
                                    block: 'popup',
                                    mods: { adaptive: 'yes', name: 'chart-bars-top' },
                                    js: {
                                        directions: 'top'
                                    },
                                    content: [
                                        { elem: 'tail' },
                                        { elem: 'content' }
                                    ]
                                },
                                {

                                    block: 'popup',
                                    mods: { adaptive: 'yes', name: 'chart-bars-bottom' },
                                    js: {
                                        directions: 'bottom'
                                    },
                                    content: [
                                        { elem: 'tail' },
                                        { elem: 'content' }
                                    ]
                                },
                                {
                                    elem: 'chart-tip',
                                    content: data.chart.tip
                                }
                            ]
                        }
                    ]
                }
            ]);
    });

    bh.match('product-chart-bars__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });
};
