module.exports = function (bh) {
    bh.match('product-chart-line', function (ctx, json) {
        var data = json.data;

        data.isMobile = bh.lib.global.isMobile;

        ctx.content([
            {
                elem: 'title',
                content: data.title
            },
            {
                mix: { block: 'html-content' },
                content: [
                    {
                        elem: 'chart-wrapper',
                        content: [
                            {
                                elem: 'chart-name',
                                content: data.chart.name
                            },
                            {
                                elem: 'legend',
                                data: data.chart.data
                            },
                            {
                                block: 'chart2',
                                js: data,
                                mods: { type: 'line' }
                            },
                            {

                                block: 'popup',
                                mods: { adaptive: 'yes', name: 'chart-line-top' },
                                js: {
                                    directions: 'top'
                                },
                                content: [
                                    { elem: 'tail' },
                                    { elem: 'content' }
                                ]
                            },
                            {
                                elem: 'chart-tip',
                                content: data.chart.tip
                            }
                        ]
                    }
                ]
            }
        ]);
    });

    bh.match('product-chart-line__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-chart-line__legend', function (ctx, json) {
        ctx.content(json.data.mainAxis.map(function (item) {
            return {
                elem: 'legend-item',
                item: item
            };
        }));
    });

    bh.match('product-chart-line__legend-item', function (ctx, json) {
        ctx.content([
            {
                elem: 'legend-dot',
                attrs: {
                    style: 'color: ' + json.item.color + ';'
                },
                content: '●'
            },
            {
                elem: 'legend-name',
                content: json.item.name
            }
        ]);
    });
};
