module.exports = function (bh) {
    bh.match('product-chart', function (ctx) {
        var data = ctx.param('data');
        var columns = data.items.map(function (item) {
            return {
                elem: 'column',
                content: [
                    {
                        elem: 'graph',
                        content: {
                            block: 'pie-chart',
                            mods: { theme: item.color },
                            value: item.value.replace(',', '.')
                        }
                    },
                    {
                        elem: 'value',
                        content: item.value + '%'
                    },
                    {
                        elem: 'text',
                        content: item.text
                    }
                ]
            };
        });

        ctx.content([
            {
                elem: 'title',
                content: data.title
            },
            data.textTop && {
                elem: 'text',
                content: data.textTop
            },
            columns.length && {
                elem: 'columns',
                content: columns
            },
            data.textBottom && {
                elem: 'text',
                content: data.textBottom
            }
        ]);
    });

    bh.match('product-chart__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-chart__text', function (ctx) {
        ctx.mix({
            block: 'html-content'
        });
    });
};
