module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-cta-2', function (ctx, json) {
        var data = json.data;
        var cta = data.cta;

        ctx.content([
            data.title && {
                tag: 'h3',
                elem: 'title',
                content: data.title
            },
            data.text && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: data.text
            },
            cta && cta.url && {
                elem: 'button',
                cta: cta
            },
            data.additionalText && {
                tag: 'p',
                elem: 'additional-text',
                mix: { block: 'html-content' },
                content: data.additionalText
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('product-cta-2__button', function (ctx, json) {
        var cta = json.cta;

        ctx.content({
            block: 'button2',
            mods: { size: 'm', theme: 'action', type: 'link' },
            url: cta.url,
            text: cta.text
        });
    });
};
