module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-cta-3', function (ctx, json) {
        var data = json.data;
        var cta = data.cta;

        ctx
            .js({
                metrikaGoalId: data.metrikaGoalId,
                scrollEndGoalId: data.scrollEndGoalId
            })
            .mods({
                color: data.color || 'gray',
                font: data.font || 'normal'
            })
            .content([
                data.title && {
                    tag: 'h3',
                    elem: 'title',
                    content: data.title
                },
                data.text && {
                    elem: 'text',
                    mix: { block: 'html-content' },
                    content: data.text
                },
                cta && cta.url && {
                    elem: 'button',
                    mods: { size: data.buttonSize },
                    cta: cta
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('product-cta-3__button', function (ctx, json) {
        var cta = json.cta;
        var size = json.elemMods.size || 'm';
        var isCta = size === 'l';

        ctx.content({
            block: 'button2',
            mods: { size: size, theme: 'action', type: 'link', cta: isCta },
            url: cta.url,
            text: cta.text
        });
    });
};
