BEM.DOM.decl('product-cta-3', {
    onSetMod: {
        js: function () {
            var button = this.findElem('button');

            if (this.params.metrikaGoalId && button) {
                this.bindTo(button, 'pointerclick', this._onButtonClick.bind(this));
            }

            if (this.params.scrollEndGoalId) {
                this._endScrollHandler = $.debounce(this._scrollEnd.bind(this), 300);

                this.bindToWin('scroll', this._endScrollHandler);
            }
        }
    },

    /**
     * По нажатию на кнопку отправляем данные в метрику
     * @private
     */
    _onButtonClick: function () {
        BEM.blocks.metrika.reachGoal(this.params.metrikaGoalId);
    },

    /**
     * Отправляем в метрику данные, когда пользователь увидел блок
     * Событие происходит при скролле до конца блока
     * @private
     */
    _scrollEnd: function () {
        BEM.blocks['i-bem'].detectScrollEnd
            .call(this, this.domElem, this.params.scrollEndGoalId, this._endScrollHandler);
    }
});
