module.exports = function (bh) {
    bh.match('product-download-file', function (ctx, json) {
        var data = json.data;
        var metrikaGoalId = data.cta && data.cta.metrikaGoalId ? data.cta.metrikaGoalId : null;

        ctx
            .js({
                metrikaGoalId: metrikaGoalId
            })
            .content({
                elem: 'content',
                title: data.title,
                text: data.text,
                cta: data.cta,
                image: data.image

            });
    });

    bh.match('product-download-file__button', function (ctx, json) {
        var cta = json.cta;

        ctx
            .content({
                block: 'button2',
                mods: { size: 'l', theme: 'action', type: 'link', cta: true },
                url: cta.url,
                target: cta.newPage ? '_blank' : '_self',
                text: cta.text
            });
    });

    bh.match('product-download-file__image-wrapper', function (ctx, json) {
        var image = json.image;

        ctx
            .content({
                block: 'image',
                mix: {
                    block: 'product-download-file',
                    elem: 'image'
                },
                url: bh.lib.util.mds(image, 'mainpage_text_large_d')
            });
    });
};
