module.exports = function (bh) {

    /* eslint-disable complexity */
    /**
     * Формирует контент блока product-features
     * @param {Object} data
     * @param {String} alignImage
     * @param {Boolean} reverse
     * @returns {Object []}
     */
    function getBlockContent(data, alignImage, reverse) {
        var textAlign = data.textAlign || 'left';
        var textType = data.textType || 'default';

        return [
            data.image && {
                elem: 'image-wrapper',
                mods: { align: alignImage },
                alignImage: alignImage,
                image: data.image,
                imageWidth: data.imageWidth,
                mobileImage: data.mobileImage
            },
            data.text && {
                elem: 'text-content',
                content: [
                    {
                        elem: 'text',
                        mix: { block: 'html-content' },
                        mods: {
                            width: data.image && 'fixed',
                            align: textAlign,
                            margin: data.textMargin && 'yes',
                            type: textType,
                            reverse: reverse
                        },
                        content: bh.lib.util.template(data.text)
                    },
                    data.inlineCta && getCta(data)
                ]
            }
        ];
    }
    /* eslint-enable complexity */

    /**
     * Возвращает кнопку CTA
     * @param {Object} data
     * @returns {Object}
     */
    function getCta(data) {
        var cta = data.cta;

        return cta && cta.url && {
            elem: 'button',
            cta: cta,
            buttonWidth: data.buttonWidth,
            inlineCta: data.inlineCta,
            mobileButtonWide: data.mobileButtonWide
        };
    }

    /* eslint-disable complexity */
    bh.match('product-features', function (ctx, json) {
        var data = json.data;
        var left = 'left';
        var alignImage = data.alignImage || left;
        var leftAlign = alignImage === left;
        var reverse = bh.lib.global.isMobile && data.mobileImageReverse;
        var htmlContent = getBlockContent(data, alignImage, reverse);

        ctx
            .js({ metrikaGoalId: data.metrikaGoalId })
            .mods({
                'background-color': data.backgroundColor,
                narrow: data.isNarrowSection && 'yes',
                columns: data.image && 'yes'
            })
            .content([
                data.theme && {
                    elem: 'theme',
                    content: data.theme
                },
                {
                    elem: 'content',
                    content: [
                        data.title && {
                            elem: 'title',
                            mods: {
                                align: data.isCenterTitle && 'center',
                                bold: data.boldTitle && 'yes',
                                font: data.titleFontSize
                            },
                            content: data.title
                        },
                        data.topText && {
                            elem: 'top-text',
                            mix: { block: 'html-content' },
                            content: data.topText
                        },
                        leftAlign || reverse ? htmlContent : htmlContent.reverse(),
                        !data.inlineCta && getCta(data)
                    ]
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('product-features__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-features__button', function (ctx, json) {
        var cta = json.cta;
        var isMobile = bh.lib.global.isMobile;
        var mobileButtonWide = isMobile && json.mobileButtonWide;

        ctx
            .mods({
                width: json.buttonWidth,
                inline: json.inlineCta
            })
            .content({
                block: 'button2',
                mods: {
                    size: 'm',
                    theme: 'action',
                    type: 'link',
                    width: (json.buttonWidth || mobileButtonWide) && 'max'
                },
                url: cta.url,
                text: cta.text
            });
    });
};
