module.exports = function (bh) {
    bh.match('product-formats', function (ctx) {
        var data = ctx.param('data');
        var formats = data.formats;
        var collapsed = formats.length > 1;
        var rowHeight = data.rowHeight || 330;

        ctx
            .js(true)
            .content([
                {
                    elem: 'title',
                    content: data.title
                },
                {
                    elem: 'formats',
                    attrs: collapsed && {
                        style: bh.lib.util.placeholder('max-height: {s}px;',
                            parseInt(rowHeight, 10))
                    },
                    formats: formats,
                    collapsed: collapsed
                },
                collapsed && {
                    elem: 'button',
                    content: {
                        block: 'button',
                        mods: { size: 'm', theme: 'normal' },
                        content: bh.lib.i18n('products', 'more')
                    }
                }
            ]);
    });

    bh.match('product-formats__title', function (ctx) {
        ctx.tag('h2');
        ctx.mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-formats__formats', function (ctx) {
        var formats = ctx.param('formats');
        var collapsed = ctx.param('collapsed');

        if (collapsed) {
            ctx.mod('collapsed', 'yes');
        }

        ctx.content([
            formats.map(function (format) {
                return {
                    elem: 'format',
                    format: format
                };
            }),
            collapsed && {
                elem: 'gradient'
            }
        ]);
    });

    bh.match('product-formats__format', function (ctx) {
        var format = ctx.param('format');

        ctx
            .content([
                {
                    elem: 'left-column',
                    image: bh.lib.util.mds(format.image),
                    imageWidth: format.imageWidth
                },
                {
                    elem: 'right-column',
                    title: format.title,
                    link: format.link,
                    linkText: format['link-text'],
                    text: format.text
                }
            ]);
    });

    bh.match('product-formats__left-column', function (ctx, json) {
        var image = json.image;
        var imageWidth = json.imageWidth;
        var attrs = { style: bh.lib.util.sizeStyle(imageWidth) };

        ctx.content({
            block: 'image',
            attrs: attrs,
            mix: { block: 'product-formats', elem: 'image' },
            url: image
        });
    });

    bh.match('product-formats__right-column', function (ctx) {
        var title = ctx.param('title');
        var link = ctx.param('link');
        var linkText = ctx.param('linkText');
        var text = ctx.param('text');

        ctx.content([
            title && {
                elem: 'format-title',
                content: title
            },
            text && {
                elem: 'format-text',
                content: text
            },
            link && linkText && {
                block: 'link',
                mods: { theme: 'normal' },
                content: linkText,
                url: link
            }
        ]);
    });
};
