module.exports = function (bh) {
    bh.match('product-formats2', function (ctx, json) {
        var data = json.data;
        var formats = data.formats;

        var type = data.type || 'dynamic-text';
        var imageAlign = data.imageAlign || 'left';

        ctx
            .js(true)
            .tParam('type', type)
            .mods({
                type: type,
                align: imageAlign
            })
            .content([
                data.title && {
                    elem: 'title',
                    content: data.title
                },
                {
                    elem: 'content',
                    text: data.text,
                    formats: formats
                }
            ]);
    });

    bh.match('product-formats2__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-formats2__formats', function (ctx, json) {
        var formats = json.formats;
        var isDynamicText = ctx.tParam('type') === 'dynamic-text';

        ctx.content({
            block: 'owl-carousel',
            mods: { type: 'dots' },
            js: {
                options: {
                    autoWidth: false,
                    dots: true,
                    dotData: bh.apply({
                        block: 'product-formats2',
                        elem: 'dot'
                    }),
                    responsive: {
                        0: {},
                        1187: {}
                    },
                    items: 1,
                    nav: false
                }
            },
            content: formats.map(function (format) {
                return bh.apply({
                    block: 'product-formats2',
                    elem: 'format',
                    mix: { block: 'clearfix' },
                    content: [
                        {
                            elem: 'format-image',
                            attrs: { style: bh.lib.util.sizeStyle(format.imageWidth) },
                            content: {
                                block: 'image',
                                url: bh.lib.util.mds(format.image, 'w200')
                            }
                        },
                        isDynamicText && {
                            elem: 'format-info',
                            content: [
                                {
                                    elem: 'format-title',
                                    content: format.title
                                },
                                {
                                    mix: {
                                        block: 'html-content'
                                    },
                                    content: format.text
                                },
                                format.url && {
                                    elem: 'button',
                                    content: {
                                        block: 'button2',
                                        mods: { theme: 'pseudo', size: 'm', type: 'link' },
                                        url: format.url,
                                        content: {
                                            elem: 'text',
                                            content: bh.lib.i18n('products', 'more.button')
                                        }
                                    }
                                }
                            ]
                        }
                    ]
                });
            })
        });
    });
};
