module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-landing', function (ctx, json) {
        var data = json.data;
        var logo = data.logo;
        var image = data.image;
        var title = data.title;
        var text = data.text;
        var button = data.button;

        ctx.content([
            (title || text || logo) && {
                elem: 'content',
                title: title,
                text: text,
                logo: logo
            },
            image && {
                tag: 'img',
                attrs: { src: image, alt: title },
                elem: 'image'
            },
            button && button.enabled && {
                elem: 'button',
                button: button
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('product-landing__info', function (ctx, json) {
        var title = json.title;
        var text = json.text;

        ctx.content([
            title && {
                elem: 'title',
                mix: { block: 'html-content' },
                content: title
            },
            text && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: text
            }
        ]);
    });

    bh.match('product-landing__logo', function (ctx, json) {
        var logo = json.logo;

        ctx.content([
            logo.image && {
                tag: 'img',
                elem: 'logo-image',
                attrs: { src: logo.image, alt: logo.text, title: logo.text }
            },
            logo.text && {
                tag: 'h6',
                elem: 'logo-text',
                content: logo.text
            }
        ]);
    });

    bh.match('product-landing__button', function (ctx, json) {
        var button = json.button;

        ctx.content({
            block: 'button2',
            mods: { size: 'm', theme: 'action', type: 'link' },
            url: button.url,
            text: button.text
        });
    });
};
