module.exports = function (bh) {
    bh.match('product-links', function (ctx, json) {
        var data = json.data;

        ctx.content([
            {
                elem: 'title',
                content: data.title
            },
            data.textTop && {
                elem: 'text',
                content: data.textTop
            },
            {
                elem: 'data',
                data: data
            },
            data.textBottom && {
                elem: 'text',
                content: data.textBottom
            }
        ]);
    });

    bh.match('product-links__title', function (ctx) {
        ctx.tag('h2');
        ctx.mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-links__data', function (ctx, json) {
        var data = json.data;
        var cards = data.items;

        ctx
            .mods({
                layout: data.layout,
                justify: data.justify ? 'yes' : ''
            })
            .content(cards.map(function (card) {
                return {
                    elem: 'column',
                    content: {
                        block: 'product-card',
                        card: card,
                        mods: { layout: data.layout }
                    }
                };
            }));
    });

    bh.match('product-links__text', function (ctx) {
        ctx.mix({
            block: 'html-content'
        });
    });
};
