module.exports = function (bh) {
    function getCard(card) {
        var hasContent = card && (card.image || card.title || card.text || card.more);

        if (!hasContent) {
            return '';
        }

        return {
            elem: 'card',
            data: card
        };
    }

    bh.match('product-media-cards', function (ctx, json) {
        var data = json.data;

        if (!data) {
            return '';
        }

        var hasCards = data.cards && data.cards.length > 0;

        ctx.content([
            data.title && {
                elem: 'title',
                tag: 'h2',
                content: data.title
            },
            data.text && {
                elem: 'text',
                mix: { block: 'html-content' },
                content: data.text
            },
            hasCards && {
                elem: 'items',
                mods: { scrollable: data.isScrollable && 'yes' },
                items: data.cards.map(getCard)
            }
        ]);
    });

    bh.match('product-media-cards__card', function (ctx, json) {
        var data = json.data;
        var url = data.url;

        ctx
            .tag(url ? 'a' : 'div')
            .attrs({ href: url })
            .content([
                {
                    elem: 'card-content',
                    content: [
                        {
                            elem: 'card-image',
                            src: data.image,
                            title: data.title,
                            hasTextOnTouchPhone: data.hasTextOnTouchPhone
                        },
                        data.title && {
                            elem: 'card-title',
                            tag: 'h3',
                            content: data.title
                        },
                        ctx.content()
                    ]
                },
                url && {
                    elem: 'card-link',
                    url: url,
                    text: data.more || bh.lib.i18n('products', 'more.button'),
                    hasMoreOnTouchPhone: data.hasMoreOnTouchPhone,
                    hasTextOnTouchPhone: data.hasTextOnTouchPhone
                }
            ], true);
    });

    bh.match('product-media-cards__card-text', function (ctx, json) {
        var text = json.text;

        if (!text) {
            return '';
        }

        ctx
            .mix({ block: 'html-content' })
            .content(text);
    });

    bh.match('product-media-cards__card-image', function (ctx, json) {
        var src = json.src;
        var title = bh.lib.util.replaceHtmlEntities(json.title);

        if (!src) {
            return '';
        }

        ctx.content({
            elem: 'img',
            tag: 'img',
            attrs: {
                src: bh.lib.util.mds(src, 'w310'),
                title: title,
                alt: title
            }
        });
    });

    bh.match('product-media-cards__card-link-icon', function (ctx) {
        ctx.content({
            block: 'icon',
            mods: {
                glyph: 'type-more'
            }
        });
    });
};
