module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-platforms', function (ctx, json) {
        var data = json.data;
        var backgroundColor = data.backgroundColor || 'transparent';

        ctx
            .mods({ 'background-color': backgroundColor })
            .content([
                data.title && {
                    elem: 'title',
                    content: data.title
                },
                data.text && {
                    elem: 'text',
                    mix: {
                        block: 'html-content'
                    },
                    content: data.text
                },
                data.items && data.items.length && {
                    elem: 'data',
                    content: data.items.map(function (item) {
                        return {
                            elem: 'column',
                            content: [
                                item.image && {
                                    elem: 'column-image',
                                    content: {
                                        block: 'image',
                                        attrs: { style: bh.lib.util.sizeStyle(item.imageWidth) },
                                        url: bh.lib.util.mds(item.image, 'w180')
                                    }
                                },
                                item.title && {
                                    elem: 'column-title',
                                    item: item
                                },
                                {
                                    elem: 'column-text',
                                    mix: {
                                        block: 'html-content'
                                    },
                                    content: item.text
                                }
                            ]
                        };
                    })
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('product-platforms__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-platforms__column-title', function (ctx, json) {
        var item = json.item;

        if (item.url) {
            ctx
                .tag('a')
                .attr('href', item.url);
        }

        ctx.content(item.title);
    });
};
