module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-price', function (ctx) {
        var data = ctx.param('data');
        var hideTableLink = ctx.param('hideTableLink') || data.hideTableLink;

        if (!data) {
            return;
        }

        if (ctx.param('hideCommonInfo') && data.information.length) {
            data.information = data.information.slice(0, 1);
        }

        ctx
            .js(true)
            .content([
                {
                    elem: 'anchor',
                    attrs: {
                        id: 'price'
                    }
                },
                data.title && !ctx.param('hideSectionTitle') && {
                    elem: 'title',
                    content: data.title
                },
                data.tableName && {
                    elem: 'subtitle',
                    mix: { block: 'clearfix' },
                    tableName: data.tableName,
                    priceUrl: !hideTableLink && data.priceUrl,
                    id: data.id
                },
                {
                    elem: 'table-wrapper',
                    content: {
                        elem: 'table',
                        header: data.header,
                        rows: data.rows
                    }
                },
                data.information.map(function (info) {
                    return {
                        elem: 'information',
                        information: info,
                        spreadInfo: ctx.param('spreadInfo')
                    };
                }),
                {
                    block: 'popup',
                    js: {
                        directions: 'bottom'
                    },
                    content: [
                        { elem: 'tail' },
                        {
                            elem: 'content'
                        }
                    ]
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('product-price__title', function (ctx) {
        ctx.tag('h2');
        ctx.mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-price__subtitle', function (ctx) {
        var priceUrl = ctx.param('priceUrl');

        ctx.content([
            {
                elem: 'table-name',
                content: ctx.param('tableName')
            },
            priceUrl && {
                elem: 'table-link',
                content: {
                    block: 'link',
                    mods: { theme: 'normal' },
                    content: bh.lib.i18n('products', 'link'),
                    url: priceUrl
                }
            }
        ]);
    });

    bh.match('product-price__table', function (ctx, json) {
        var header = json.header;
        var rows = json.rows;

        ctx
            .tag('table')
            .content([
                header && header.length > 0 && {
                    tag: 'thead',
                    content: {
                        tag: 'tr',
                        content: header.map(function (cell) {
                            return {
                                tag: 'th',
                                content: [
                                    cell.tip && {
                                        elem: 'table-tip',
                                        attrs: {
                                            alt: cell.tip
                                        }
                                    },
                                    cell.text
                                ]
                            };
                        })
                    }
                },
                rows && rows.length > 0 && {
                    tag: 'tbody',
                    content: rows.map(function (row) {
                        return {
                            tag: 'tr',
                            content: row.map(function (cell) {
                                return {
                                    tag: 'td',
                                    content: cell
                                };
                            })
                        };
                    })
                }
            ]);
    });

    /* eslint-disable complexity */
    bh.match('product-price__information', function (ctx) {
        var information = ctx.param('information');
        var spreadInfo = ctx.param('spreadInfo');

        if (!information || !information.title || !information.text) {
            return '';
        }

        ctx.content([
            !spreadInfo && {
                elem: 'information-toggle',
                content: information.title
            },
            {
                elem: 'information-text',
                mix: { block: 'html-content' },
                content: information.text,
                mods: {
                    visible: spreadInfo ? 'yes' : false
                }
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('product-price__information-toggle', function (ctx) {
        ctx
            .tag('span')
            .content([
                ctx.content(),
                {
                    block: 'icon',
                    mods: {
                        type: 'arrow',
                        direction: 'bottom'
                    }
                }
            ], true);
    });
};
