BEM.DOM.decl('product-price', {

    onSetMod: {
        js: function () {
            this._toggles = this.elem('information-toggle');
            this._priceTips = this.elem('table-tip');
            this._popup = this.findBlockInside('popup');
            this._bindEvents();
        }
    },

    _bindEvents: function () {
        this._toggles.on('click', this._onToggle.bind(this));
        this._priceTips.on('click', this._onPriceTipClick.bind(this));
    },

    _onToggle: function (e) {
        var $elem = $(e.currentTarget);
        var icon = this.findBlockInside($elem, 'icon');

        this.toggleMod($elem, 'expanded', 'yes');
        icon.toggleMod('direction', 'bottom', 'top');
        this.domElem.trigger('content-change');
    },

    _onPriceTipClick: function (e) {
        var $elem = $(e.currentTarget);

        this._popup
            .setContent($elem.attr('alt'))
            .toggle($elem);
    }
});
