module.exports = function (bh) {
    bh.match('product-similar', function (ctx) {
        var data = ctx.param('data');
        var productsListUrl = ctx.param('productsListUrl');

        if (!data.products.length) {
            return '';
        }

        ctx.content([
            {
                elem: 'title',
                content: data.title
            },
            {
                elem: 'products',
                data: data,
                productsListUrl: productsListUrl
            }
        ]);
    });

    bh.match('product-similar__title', function (ctx) {
        ctx.tag('h2');
        ctx.mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-similar__products', function (ctx) {
        var data = ctx.param('data');

        var products = data.products.map(function (product, i) {
            var remainder = (i + 1) % 3;

            return [
                {
                    elem: 'product',
                    mods: {
                        left: remainder === 1,
                        right: remainder === 0
                    },
                    content: [
                        {
                            elem: 'product-title',
                            content: product.title
                        },
                        {
                            mix: {
                                block: 'html-content'
                            },
                            elem: 'product-description',
                            content: product.teaser
                        },
                        {
                            block: 'link',
                            mods: { theme: 'more' },
                            mix: {
                                block: 'product-similar',
                                elem: 'product-link'
                            },
                            text: bh.lib.i18n('products', 'more.button'),
                            iconRight: {
                                block: 'icon',
                                mods: {
                                    glyph: 'type-more'
                                },
                                mix: {
                                    block: 'product-similar',
                                    elem: 'product-link-icon'
                                }
                            },
                            url: [
                                ctx.param('productsListUrl'),
                                product.section,
                                product.slug
                            ].join('/')
                        }

                    ]
                }
            ];
        });

        ctx.content(products);
    });
};
