module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('product-targetings', function (ctx, json) {
        var data = json.data;
        var isAdvanced = data.layout === 'advanced';
        var collapsed = !isAdvanced && data.targetings.length > 3;
        var rowHeight = data.rowHeight || 400;

        ctx
            .js({
                isAdvanced: isAdvanced
            })
            .mods({
                layout: isAdvanced ? 'advanced' : 'common',
                type: json.page
            })
            .content([
                {
                    elem: 'title',
                    content: data.title
                },
                {
                    elem: 'wrapper',
                    content: [
                        {
                            elem: 'text',
                            mix: {
                                block: 'html-content'
                            },
                            content: data.text
                        },
                        {
                            elem: 'targetings',
                            attrs: collapsed && {
                                style: bh.lib.util.placeholder('max-height: {s}px;',
                                    parseInt(rowHeight, 10))
                            },
                            data: data,
                            collapsed: collapsed,
                            isAdvanced: isAdvanced
                        }
                    ]
                },
                collapsed && {
                    elem: 'button',
                    content: {
                        block: 'button',
                        mods: { size: 'm', theme: 'normal' },
                        content: bh.lib.i18n('products', 'more')
                    }
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('product-targetings__title', function (ctx) {
        ctx.tag('h2');
        ctx.mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-targetings__targetings', function (ctx, json) {
        var data = json.data;
        var collapsed = json.collapsed;
        var isAdvanced = json.isAdvanced;

        if (collapsed) {
            ctx.mod('collapsed', 'yes');
        }

        var select = isAdvanced && [
            {
                elem: 'select-label',
                mix: {
                    block: 'html-content'
                },
                content: bh.lib.i18n('products', 'targetings')
            },
            {
                elem: 'select',
                content: {
                    block: 'select',
                    mods: { size: 'm', theme: 'normal' },
                    content: [
                        {
                            block: 'button',
                            mods: { theme: 'normal' },
                            content: data.targetings[0].title
                        },
                        {
                            elem: 'control',
                            content: data.targetings.map(function (targeting) {
                                return {
                                    elem: 'option',
                                    attrs: { value: targeting.id },
                                    content: targeting.title
                                };
                            })
                        }
                    ]
                }
            }
        ];

        var targetings = data.targetings.map(function (targeting, i) {
            return [
                {
                    elem: 'targeting',
                    mods: {
                        id: targeting.id,
                        hidden: i > 0 ? 'yes' : 'no'
                    },
                    content: [
                        {
                            elem: 'targeting-image',
                            content: {
                                block: 'image',
                                attrs: { style: bh.lib.util.sizeStyle(targeting.imageWidth) },
                                url: bh.lib.util.mds(targeting.image, 'w180')
                            }
                        },
                        {
                            elem: 'targeting-title',
                            content: targeting.title
                        },
                        {
                            mix: {
                                block: 'html-content'
                            },
                            content: targeting.description
                        }
                    ]
                }
            ];
        });

        ctx.content([
            select,
            targetings,
            collapsed && {
                elem: 'gradient'
            }
        ]);

        if (isAdvanced) {
            ctx.content({
                elem: 'column',
                content: ctx.content()
            }, true);
        }
    });
};
