BEM.DOM.decl('product-targetings', {

    onSetMod: {
        js: function () {
            this._initCollapse();
            this._initSelect();
        }
    },

    _onContainerSpread: function () {
        this.setMod(this.elem('button'), 'visibility', 'hidden');
        /* eslint-disable max-len */
        this._container
            .css('max-height', 5000)
            .one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
                this.delMod(this._container, 'collapsed');
            }.bind(this));
    },

    _onSelectChange: function () {
        this.setMod(this._target, 'hidden', 'yes');
        this._target = this.findElem('targeting', 'id', this._select.val());
        this.setMod(this._target, 'hidden', 'no');
    },

    _initCollapse: function () {
        this._container = this.elem('targetings');

        if (!this.hasMod(this._container, 'collapsed')) {
            return;
        }

        this._button = this.findBlockInside('button');
        this._button.onFirst('click', this._onContainerSpread.bind(this));
    },

    _initSelect: function () {
        if (!this.params.isAdvanced) {
            return;
        }

        this._target = this.findElem('targeting', 'hidden', 'no');
        this._select = this.findBlockInside('select');
        this._select.on('change', this._onSelectChange.bind(this));
    }
});
