module.exports = function (bh) {
    var findDefaultTabId = function (tabs) {
        for (var i = 0; i < tabs.length; i += 1) {
            if (tabs[i].isDefailt) {
                return tabs[i].id;
            }
        }

        return null;
    };

    var getSelectedTabId = function (defaultTabId) {
        var query = bh.lib.global.query;

        return query && query.tab || defaultTabId;
    };

    bh.match('product-toggle-tabs', function (ctx, json) {
        var tabs = json.data.items;
        var defaultId = findDefaultTabId(tabs);

        ctx
            .js(true)
            .content([
                {
                    elem: 'title',
                    content: json.data.title
                },
                json.data.textTop && {
                    elem: 'text',
                    content: json.data.textTop
                },
                {
                    elem: 'cards',
                    tabs: tabs.map(function (tab) {
                        return { card: tab.card, id: tab.id };
                    })
                },
                {
                    elem: 'content',
                    tabsContent: tabs.map(function (tab) {
                        return { content: tab.content, id: tab.id };
                    }),
                    defaultId: defaultId
                },
                json.data.textBottom && {
                    elem: 'text',
                    content: json.data.textBottom
                }
            ]);
    });

    bh.match('product-toggle-tabs__title', function (ctx) {
        ctx
            .tag('h2')
            .mix({ block: 'products-info', elem: 'section-title' });
    });

    bh.match('product-toggle-tabs__cards', function (ctx, json) {
        var tabs = json.tabs;
        var selectedTabId = getSelectedTabId(json.defaultId);

        ctx
            .content(
                tabs.map(function (tab) {
                    var query = bh.lib.global.query;

                    if (query) {
                        query = bh.lib.util.clone(bh.lib.global.query);
                        query.tab = tab.id;
                    }

                    return {
                        elem: 'card-wrap',
                        tag: 'a',
                        attrs: { href: query ? '?' + bh.lib.util.stringifyQuery(query) : '' },
                        content: {
                            block: 'product-card',
                            card: tab.card,
                            mods: {
                                layout: 'cards',
                                selected: tab.id === selectedTabId ? 'yes' : null,
                                id: tab.id
                            }
                        }
                    };
                }, this)
            );
    });

    bh.match('product-toggle-tabs__content', function (ctx, json) {
        var selectedTabId = getSelectedTabId(json.defaultId);
        var tabsContent = json.tabsContent;

        ctx
            .content(
                tabsContent.map(function (tabContent) {
                    return {
                        elem: 'content-text',
                        mix: { block: 'html-content' },
                        content: tabContent.content,
                        elemMods: {
                            show: selectedTabId === tabContent.id ? 'yes' : null,
                            id: tabContent.id
                        }
                    };
                }, this)
            );
    });

    bh.match('product-toggle-tabs__text', function (ctx) {
        ctx.mix({
            block: 'html-content'
        });
    });
};
