BEM.DOM.decl('product-toggle-tabs', {
    onSetMod: {
        js: function () {
            this.bindEvents();
        }
    },

    bindEvents: function () {
        this.bindTo(this.findElem('card-wrap'), 'pointerclick', this._toggleTabs.bind(this));
    },

    _toggleTabs: function (e) {
        if (typeof e.preventDefault === 'function') {
            e.preventDefault();
        }

        var targetTabId = BEM.blocks['i-bem'].decodeQuery(e.currentTarget.search).tab;
        var query = BEM.blocks['i-bem'].decodeQuery(window.location.search);

        if (query.tab === targetTabId) {
            return false;
        }

        if (typeof window.history.replaceState === 'function') {
            query.tab = targetTabId;
            var newQuery = $.param(query);

            window.history.replaceState(null, null, newQuery ? '?' + newQuery : null);
        }

        this._changeView(targetTabId);

        e.returnValue = false;

        return false;
    },

    _changeView: function (targetTabId) {
        this.delMod(this.elem('content-text', 'show', 'yes'), 'show');
        this.setMod(this.elem('content-text', 'id', targetTabId), 'show', 'yes');

        var selectedBlock = this.findBlockInside({
            block: 'product-card',
            modName: 'selected',
            modVal: 'yes' });

        var targetBlock = this.findBlockInside({
            block: 'product-card',
            modName: 'id',
            modVal: targetTabId
        });

        if (selectedBlock) {
            selectedBlock.delMod('selected');
        }

        if (targetBlock) {
            targetBlock.setMod('selected', 'yes');
        }
    }
});
