module.exports = function (bh) {
    bh.match('publisher-schema', function (ctx, json) {
        var data = json.data;

        ctx.content([
            {
                elem: 'picture',
                image: data.imageUrl,
                text: data.text
            },
            {
                elem: 'texts-sidebar',
                texts: data.texts
            }
        ]);
    });

    bh.match('publisher-schema__picture', function (ctx, json) {
        var text = json.text;

        ctx.content({
            elem: 'img',
            tag: 'img',
            attrs: {
                src: json.image,
                alt: text,
                title: text
            }
        });
    });

    bh.match('publisher-schema__texts-sidebar', function (ctx, json) {
        var texts = json.texts;

        ctx.content(texts && texts.length ? texts.map(function (text) {
            return {
                elem: 'text',
                content: text
            };
        }) : null);
    });
};
