module.exports = function (bh) {
    function buildItem(item) {
        return {
            block: 'related-articles',
            elem: 'item',
            data: item
        };
    }

    bh.match('related-articles', function (ctx, json) {
        var items = json.items;
        var isCarousel = items.length > 3 && !bh.lib.global.isMobile;

        ctx.content([
            {
                elem: 'title',
                title: json.title
            },
            isCarousel ? {
                elem: 'carousel-wrapper',
                content: {
                    block: 'owl-carousel',
                    mods: { type: 'arrows' },
                    js: {
                        options: {
                            responsive: false,
                            rewind: false,
                            nav: true,
                            loop: false,
                            items: 3,
                            stagePadding: 0
                        }
                    },
                    content: items.map(buildItem)
                }
            } : {
                elem: 'list',
                content: items.map(buildItem)
            },
            ctx.content()
        ], true);
    });

    bh.match('related-articles__item', function (ctx, json) {
        var item = json.data;

        ctx
            .tag('article')
            .content([
                {
                    elem: 'link',
                    content: {
                        block: 'link',
                        mods: {
                            theme: 'black'
                        },
                        url: item.url,
                        content: {
                            block: 'related-articles',
                            elem: 'text',
                            content: item.title
                        }
                    }
                },
                {
                    elem: 'info',
                    content: [
                        item.date && {
                            elem: 'date',
                            content: item.date
                        },
                        item.commentsCount && {
                            block: 'comments-count',
                            commentsData: item.commentsCount
                        }
                    ]
                }
            ]);
    });

    bh.match('related-articles__title', function (ctx, json) {
        var title = json.title || bh.lib.i18n('news', 'related.title');

        ctx.content(title);
    });

    bh.match('related-articles__date', function (ctx) {
        ctx.tag('time');
    });
};
