module.exports = function (bh) {
    bh.match('requirements-info_page_nested', function (ctx, json) {
        var data = json.data;
        var isMobile = bh.lib.global.isMobile;

        ctx
            .js(true)
            .content([
                isMobile && {
                    elem: 'back',
                    data: data
                },
                {
                    elem: 'title',
                    content: data.pageInfo.title
                },
                {
                    elem: 'subtitle',
                    content: data.pageInfo.subtitle
                },
                {
                    elem: 'text',
                    mix: [
                        { block: 'html-content' },
                        { block: 'page-content' }
                    ],
                    content: data.pageInfo.text
                }
            ]);
    });

    bh.match('requirements-info__back', function (ctx, json) {
        var data = json.data;

        ctx.content([
            {
                block: 'link',
                mods: { theme: 'normal' },
                url: data.requirementsPageUrl,
                content: '← ' + bh.lib.i18n('menu', 'menu')
            }
        ]);
    });

    bh.match('requirements-info__title', function (ctx) {
        ctx.tag('h2');
    });

    bh.match('requirements-info__subtitle', function (ctx) {
        ctx.tag('h3');
    });
};
