'use strict';

/**
 * Подключает карты yamaps
 * @param {Object} data
 * @returns {Array}
 * @private
 */
var _getMapsScript = function (data) {
    if (!data.mapsApi) {
        return;
    }

    return Object.keys(data.mapsApi).map(function (key) {
        var api = data.mapsApi[key];

        return [
            {
                block: 'b-page',
                elem: 'js',
                url: api.js
            },
            api.css && {
                elem: 'css',
                url: api.css
            }
        ];
    });
};

/**
 * Подключает шэринг ya-share2
 * @param {Object} data
 * @returns {{block: string, elem: string, url: *}}
 * @private
 */
var _getShareScript = function (data) {
    return {
        block: 'b-page',
        elem: 'js',
        url: data.shareScript
    };
};

/**
 * Подключает подсветку синтаксиса hljs
 * @param {Object} data
 * @returns {Array}
 * @private
 */
var _getHljsScript = function (data) {
    if (!data.hljs) {
        return;
    }

    return [
        {
            block: 'b-page',
            elem: 'js',
            url: data.hljs.js
        },
        {
            block: 'b-page',
            elem: 'css',
            url: data.hljs.css
        }
    ];
};

/* eslint-disable complexity */
var _getPageScripts = function (data) {
    switch (data.page) {
        case 'offices':
        case 'agency':
            return _getMapsScript(data);
        case 'requirements':
            return _getHljsScript(data);
        case 'products':
        case 'solution':
        case 'news':
        case 'news-list':
        case 'online-edu-lesson':
        case 'index':
        case 'journals':
            return _getShareScript(data);
        case 'event':
            return [
                _getMapsScript(data),
                _getShareScript(data)
            ];
        default:
            return;
    }
};

module.exports = function (blocks) {
    blocks.declare('scripts-loader', function (data) {
        var pageScripts = _getPageScripts(data);
        var unsupportedBrowser = [{
            block: 'b-page',
            elem: 'js',
            url: data.urlBrowserUpdater
        },
        {
            block: 'b-page',
            elem: 'js',
            /* eslint-disable max-len */
            content: 'var yaBrowserUpdater=new ya.browserUpdater.init({"lang":"ru","browsers":{"ie":"8","opera":"11.6","fx":"15","iron":"35","flock":"Infinity","palemoon":"25","camino":"Infinity","maxthon":"4.5","seamonkey":"2.3"},"theme":"red"});'
        }];

        if (pageScripts) {
            return unsupportedBrowser.concat(pageScripts);
        }

        return unsupportedBrowser;
    });
};
