BEM.DOM.decl('scroll-to', {}, {
    _scrollElement: $('html, body'),
    _options: {
        animationDuration: 300,
        offsetTop: 0 // Высота отступа сверху
    },

    /**
     * Определяет позицию, к которой нужно проскроллить
     * на основе типа значения, которое пришло
     * @param {Block|jQuery|Number|String} value
     * @returns {Number}
     * @private
     */
    _getPosition: function (value) {
        // Если пришло число, то сразу перемещаем
        if (typeof value === 'number') {
            return value;
        }

        // Иначе это будет объект, у которого мы получим позицию
        var $elem = null;

        if (value instanceof BEM) {
            $elem = value.domElem;
        } else if (value instanceof $) {
            $elem = value;
        } else if (typeof value === 'string') {
            $elem = $(value);
        } else {
            // Если это не Block, не jQuery-объект и
            // Не строка-селектор, то скроллим вверх
            return 0;
        }

        // Отдаем позицию объекта
        return $elem.offset().top;
    },

    scrollTo: function (value, options, callback) {
        if (this._scrollElement.is(':animated')) {
            return;
        }

        options = $.extend({}, this._options, options);

        this._scrollElement.animate(
            { scrollTop: this._getPosition(value) - options.offsetTop },
            options.animationDuration,
            callback
        );
    }
});
