BEM.DOM.decl('search-action', {

    onSetMod: {
        js: function () {
            var self = this;

            this.bindTo(this._getIcon(), 'leftclick tap', function () {
                self._showForm();
            });

            this._getInput().on('focus', function () {
                self._showForm();
            });
            this._getInput().on('blur', function () {
                self._hideForm();
            });
        }
    },

    _formIsHidden: function () {
        return this.getMod('form') === 'hidden';
    },

    _getIcon: function () {
        return this.elem('icon');
    },

    _getInput: function () {
        if (this.__input__) {
            return this.__input__;
        }

        this.__input__ = this.findBlockInside('input');

        return this.__input__;
    },

    _showForm: function () {
        if (this._formIsHidden()) {
            this.delMod('form');
            this._getInput().setMod('focused', 'yes');
        }
    },

    _hideForm: function () {
        if (!this._formIsHidden()) {
            this.setMod('form', 'hidden');
        }
    }
});
