module.exports = function (bh) {
    function getDropdown(fieldName) {
        return {
            block: 'dropdown2',
            mods: {
                switcher: 'button2',
                theme: 'normal',
                size: 's',
                width: 'max',
                preset: fieldName,
                'has-tick': 'yes'
            },
            switcher: bh.lib.i18n('agencies', fieldName),
            popup: {
                mix: {
                    block: 'popup2',
                    mods: { order: 'top' }
                },
                mods: { theme: 'normal' },
                directions: ['bottom-left'],
                content: ''
            }
        };
    }

    /* eslint-disable complexity */
    bh.match('search-filter', function (ctx, json) {
        var agencySearch = json.agencySearch;
        var filters = json.filters;
        var controls = json.controls || [
            agencySearch.citiesByCountries.length > 1 && getDropdown('country'),
            getDropdown('city'),
            agencySearch.services && agencySearch.services.length && getDropdown('service')
        ];

        ctx
            .attr('role', 'search')
            .content([
                {
                    elem: 'label',
                    content: json.label || bh.lib.i18n('agencies', 'specify')
                },
                controls.map(function (control) {
                    if (!control) {
                        return;
                    }

                    return {
                        elem: 'col',
                        content: control
                    };
                }),
                filters && filters.map(function (filter) {
                    if (!filter) {
                        return '';
                    }

                    return {
                        block: 'filters',
                        elem: 'filter',
                        attrs: { 'data-dependent': filter.dependent },
                        data: filter
                    };
                })
            ]);
    });
    /* eslint-enable complexity */

    bh.match('search-filter__spinner', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: { size: 'l', progress: 'yes' }
        });
    });
};
