BEM.DOM.decl('search-filter', {

    onSetMod: {
        js: {
            inited: function () {
                this._citiesByCountries = this.params.citiesByCountries;
                this._cities = this._citiesByCountries.reduce(function (arr, country) {
                    return arr.concat(country.cities);
                }, []);

                var services = this.params.services;

                this._services = services && services.length ? services : false;
                this._agenciesFilters = this.params.agenciesFilters;

                this._findElems();
                this._bindEvents();

                this._buildData();

                BEM.blocks['i-bem'].reachTime('vremya');
            }
        }
    },

    /**
     * Строит дропдаун по параметрам
     * @param {Object} props
     * @private
     */
    _buildDropdown: function (props) {
        var content = props.list.map(function (item, index) {
            return {
                block: 'search-filter',
                elem: 'popup-item',
                content: {
                    block: 'checkbox',
                    mods: {
                        size: 's',
                        theme: 'normal',
                        checked: props.selected.indexOf(item.geo_id || item.id) > -1 ? 'yes' : false
                    },
                    checkboxAttrs: {
                        id: 'search-filter-' + props.name + '_' + index,
                        value: item.geo_id || item.id
                    },
                    attrs: {
                        'data-name': props.name,
                        'data-goal': this._getGoalByDropdown(item, props.name)
                    },
                    text: item.name
                }
            };
        }, this);

        BEM.DOM.update(props.popup.domElem, BH.apply({
            block: 'search-filter',
            elem: 'popup',
            content: content
        }), props.cb, this);
    },

    /**
     * Получает идентификатор цели по названию дропдауна
     * @param {Object} item
     * @param {String} name
     * @returns {String|*}
     * @private
     */
    _getGoalByDropdown: function (item, name) {
        switch (name) {
            case 'city':
                return 'GOROD';
            case 'service':
                return item.metrikaGoalId;
            default:
                return;
        }
    },

    /* eslint-disable complexity */
    /**
     * Наполняем дропдауны данными
     * @private
     */
    _buildData: function () {
        /* eslint-disable no-unused-expressions */
        var selectedCountries = this._agenciesFilters.countries || [];
        var selectedCities = this._agenciesFilters.cities || [];
        var selectedServices = this._agenciesFilters.services || [];

        this._initedFiltersCount = [
            this._country && selectedCountries,
            this._city && selectedCities,
            this._services && selectedServices
        ]
            .filter(function (collection) {
                return collection && collection.length > 0;
            }, this)
            .length;

        this._country && this._buildDropdown({
            name: 'country',
            popup: this._country.getPopup(),
            list: this._citiesByCountries,
            selected: selectedCountries,
            cb: this._updateCountryBtn
        });

        if (this._city) {
            var allCities = this._citiesByCountries.reduce(function (memo, country) {
                if (!selectedCountries.length || selectedCountries.indexOf(country.geo_id) > -1) {
                    return memo.concat(country.cities);
                }

                return memo;
            }, []);

            this._buildDropdown({
                name: 'city',
                popup: this._city.getPopup(),
                list: allCities,
                selected: selectedCities,
                cb: this._updateCityBtn
            });
        }

        this._services && this._buildDropdown({
            name: 'service',
            popup: this._service.getPopup(),
            list: this._services,
            selected: selectedServices,
            cb: this._updateServiceBtn
        });

        this._toggleDependentFilters(true);
    },
    /* eslint-enable complexity */

    _findElems: function () {
        this._findDropdowns();

        this._bPage = this.findBlockOutside('b-page');
        this._layout = this._bPage.findBlockInside('main-layout').findElem('column');
        this._agenciesList = this._bPage.findBlockInside('agency-list');
        this._checkboxes = this._bPage.findBlocksInside('checkbox');
        this._filters = this.domElem.find('.filters__filter');

        this._isServerFree = true;
        this._more = this.params.more;
        this.agenciesCount = this.params.agenciesCount;
    },

    _findDropdowns: function () {
        this._country = this.findBlockInside({
            block: 'dropdown2',
            modName: 'preset',
            modVal: 'country'
        });

        this._city = this.findBlockInside({
            block: 'dropdown2',
            modName: 'preset',
            modVal: 'city'
        });

        if (this._country) {
            this._defaultCountryText = this._country.getSwitcher().getText();
        }

        this._defaultCityText = this._city.getSwitcher().getText();

        if (this._services) {
            this._service = this.findBlockInside({
                block: 'dropdown2',
                modName: 'preset',
                modVal: 'service'
            });
            this._defaultServiceText = this._service.getSwitcher().getText();
        }
    },

    _bindEvents: function () {
        /* eslint-disable no-unused-expressions */
        this._country && this._country.on('beforeClose', this._filterCity.bind(this));
        this._city.on('beforeClose', this._updateCityBtn.bind(this));

        if (this._services) {
            this._service.on('beforeClose', this._updateServiceBtn.bind(this));
        }

        if (this._agenciesList) {
            this.bindToWin('scroll', this._onScroll.bind(this));
        }

        BEM.blocks.checkbox.on(this._bPage.domElem, 'change', this._onFiltersChange.bind(this));
        BEM.blocks.dropdown2.on(this._bPage.domElem, 'beforeClose',
            this._onDropdownClose.bind(this));
    },

    /**
     * Обработчик смены значения для фильтрации
     * @param {Object} e
     * @private
     */
    _onFiltersChange: function (e) {
        if (e.block.domElem.data('name') === 'service') {
            this._toggleDependentFilters();
        }

        if (this.params.ajax && this._initedFiltersCount > 0) {
            this._initedFiltersCount -= 1;

            return;
        }

        this._more = true;
        this.agenciesCount = 0;

        var filters = $.extend(this.getData(), this._getFilters());

        this._reachGoal(e.block.domElem.data('goal'));

        if (this.params.ajax) {
            this._getAgencies(filters, true);
        }

        this._changeUrl(filters);
    },

    /**
     * Отправляет данные в метрику
     * @param {String|*} goal
     * @private
     */
    _reachGoal: function(goal) {
        if (goal) {
            BEM.blocks.metrika.reachGoal(goal);
        }
    },

    /**
     * При закрытии попапа меняем текст на кнопке
     * @param {Object} e
     * @private
     */
    _onDropdownClose: function (e) {
        var $target = e.block.domElem;
        var slug = $target.data('slug');

        if (!slug) {
            return;
        }

        var button = this.findBlockInside($target, 'button2');
        var buttonText = this._checkboxes
            .filter(function (checkbox) {
                return checkbox.domElem.data('slug') === slug && checkbox.isChecked();
            })
            .map(function (checkbox) {
                return checkbox.domElem.data('value');
            })
            .join(', ');

        button.setText(buttonText || $target.data('name'));
    },

    /**
     * Обработчик проматывания списка агентств
     * @private
     */
    _onScroll: function () {
        if (!this._isServerFree || !this._more) {
            return;
        }

        var isReached = BEM.blocks['i-bem'].detectScrollEnd(this._agenciesList.domElem);
        var filters = $.extend(this.getData(), this._getFilters());

        if (isReached) {
            this._getAgencies(filters);
        }
    },

    /**
     * Делает запрос к серверу, получает список агентств
     * @param {Object} filters
     * @param {Boolean} force - очистить список
     * @private
     */
    _getAgencies: function (filters, force) {
        this._isServerFree = false;
        this._runSpinner();

        var requestOptions = {
            type: 'POST',
            url: this.params.filterUrl,
            contentType: 'application/json',
            data: JSON.stringify($.extend({
                startIdx: this.agenciesCount,
                permutation: this.params.permutation
            }, filters))
        };

        $.ajax(requestOptions)
            .done(function (data) {
                if (force) {
                    BEM.blocks['agency-list'].clear();
                }

                this._addAgencies(data);
            }.bind(this))
            .fail(this._showErrorMessage.bind(this))
            .always(this._hideSpinner.bind(this));
    },

    /**
     * Показывает спиннер.
     * @private
     */
    _runSpinner: function () {
        if (!this._$spinner) {
            this._$spinner = $(BH.apply({
                block: 'search-filter',
                elem: 'spinner'
            }));

            BEM.DOM.append(this._layout, this._$spinner);
        }
    },

    /**
     * Меняет контент списка агентств
     * @param {{list: Object [], more: Boolean}} data
     * @returns {null}
     * @private
     */
    _addAgencies: function (data) {
        var list = data && data.list;

        if (!Array.isArray(list)) {
            return this._showErrorMessage();
        }

        this._more = data.more;
        this.agenciesCount += list.length;

        BEM.blocks['agency-list'].append(list);
    },

    /**
     * Скрывает спиннер
     * @private
     */
    _hideSpinner: function () {
        this._isServerFree = true;

        if (this._$spinner) {
            BEM.DOM.destruct(this._$spinner);
            this._$spinner = null;
        }
    },

    /**
     * Показывает сообщение об ошибке
     * @private
     */
    _showErrorMessage: function () {
        var failMessage = BH.lib.i18n('solutions', 'error');

        BEM.blocks['notifications-list'].notify(failMessage);
    },

    /**
     * Фильтруем города по выбранным странам
     * @private
     */
    _filterCity: function () {
        var citiesByCountries = this._citiesByCountries;
        var selected = this._getSelectedCountries().map(function (id) {
            /* eslint-disable camelcase */
            return BEM.blocks['i-bem'].findById(citiesByCountries, { geo_id: id });
        });
        var countries = selected;

        if (!selected.length) {
            countries = this._citiesByCountries;
        }

        var cities = countries.reduce(function (arr, country) {
            return arr.concat(country.cities);
        }, []);

        this._changeCountryText(selected);
        this._drawCityContent(cities);
    },

    /**
     * Перерисовываем попап с городами
     * @param {Array} cities
     * @private
     */
    _drawCityContent: function (cities) {
        var selectedCities = this._getSelectedCities();
        var popup = this._city.getPopup();

        BEM.DOM.update(popup.domElem, this._buildCityContent(cities, selectedCities), function () {
            this._updateCityBtn();
        }, this);
    },

    _changeCountryText: function (countries) {
        var btn = this._country.getSwitcher();

        if (countries.length) {
            btn.setText(BEM.blocks['i-bem'].pluck(countries, 'name').join(', '));
        } else {
            btn.setText(this._defaultCountryText);
        }
    },

    _changeCityText: function (cities) {
        var btn = this._city.getSwitcher();

        if (cities.length) {
            btn.setText(BEM.blocks['i-bem'].pluck(cities, 'name').join(', '));
        } else {
            btn.setText(this._defaultCityText);
        }
    },

    _changeServiceText: function (services) {
        var btn = this._service.getSwitcher();

        if (services.length) {
            btn.setText(BEM.blocks['i-bem'].pluck(services, 'name').join(', '));
        } else {
            btn.setText(this._defaultServiceText);
        }
    },

    _getCheckboxValuesInBlock: function (block, isNum) {
        var checkboxes = block.findBlocksInside('checkbox');
        var selected = [];

        checkboxes.forEach(function (checkbox) {
            if (checkbox.isChecked()) {
                return selected.push(isNum ? Number(checkbox.val()) : checkbox.val());
            }
        });

        return selected;
    },

    _getSelectedCountries: function () {
        if (!this._country) {
            return [];
        }

        return this._getCheckboxValuesInBlock(this._country.getPopup(), true);
    },

    _getSelectedCities: function () {
        return this._getCheckboxValuesInBlock(this._city.getPopup(), true);
    },

    _getSelectedServices: function () {
        if (!this._service) {
            return [];
        }

        return this._getCheckboxValuesInBlock(this._service.getPopup());
    },

    /**
     * Получает данные из произвольных фильтров
     * @returns {Object}
     * @private
     */
    _getFilters: function () {
        return this._checkboxes.reduce(function (filter, checkbox) {
            var $checkbox = checkbox.domElem;
            var slug = $checkbox.data('slug');

            if (checkbox.isChecked() && slug) {
                var value = encodeURIComponent($checkbox.data('value'));

                if (Object.hasOwnProperty.call(filter, slug)) {
                    filter[slug].push(value);
                } else {
                    filter[slug] = [value];
                }
            }

            return filter;
        }, {});
    },

    _updateCountryBtn: function () {
        var selected = this._getSelectedCountries();
        var countries = this._citiesByCountries.filter(function (item) {
            return selected.indexOf(item.geo_id) > -1;
        });

        this._changeCountryText(countries);
    },

    _updateCityBtn: function () {
        var allCities = this._cities;
        var cities = this._getSelectedCities().map(function (id) {
            /* eslint-disable camelcase */
            return BEM.blocks['i-bem'].findById(allCities, { geo_id: id });
        });

        this._changeCityText(cities);
    },

    _updateServiceBtn: function () {
        var allServices = this._services;
        var services = this._getSelectedServices().map(function (id) {
            return BEM.blocks['i-bem'].findById(allServices, { id: id });
        });

        this._changeServiceText(services);
    },

    /* eslint-disable complexity */
    /**
     * Переключает состояние зависимого фильтра. Если выбран нужный сервис,
     * то делаем фильтр активным.
     * @param {Boolean} forceDisable
     * @private
     */
    _toggleDependentFilters: function (forceDisable) {
        var services = this._getSelectedServices()
            .map(function (id) {
                var service = BEM.blocks['i-bem'].findById(this._services, { id: id }) || {};

                return service.name;
            }, this);

        for (var idx = 0; idx < this._filters.length; idx += 1) {
            var $filter = $(this._filters[idx]);
            var serviceName = $filter.data('dependent');

            if (serviceName) {
                var button = this.findBlockInside($filter, 'button2');
                var isServiceSelected = services.indexOf(serviceName) > -1;

                forceDisable ? !isServiceSelected && button.setMod('disabled', 'yes') :
                    button.toggleMod('disabled', '', 'yes', isServiceSelected);
                !isServiceSelected && this._resetFilterCheckboxes($filter);
            }
        }
    },
    /* eslint-enable complexity */

    /**
     * Сбрасывает значения произвольного фильтра
     * @param {jQuery} $filter
     * @private
     */
    _resetFilterCheckboxes: function ($filter) {
        var dropdown = this.findBlockInside($filter, 'dropdown2');
        var button = this.findBlockInside($filter, 'button2');
        var slug = dropdown && dropdown.domElem.data('slug');
        var name = dropdown && dropdown.domElem.data('name');
        var checkboxes = this.findBlocksInside(this._bPage.domElem, 'checkbox');

        checkboxes.forEach(function (checkbox) {
            if (checkbox.isChecked() && checkbox.domElem.data('slug') === slug) {
                checkbox.toggle();
            }
        });

        if (button && name) {
            button.setText(name);
        }
    },

    _buildCityContent: function (cities, selectedCities) {
        return BH.apply({
            block: 'search-filter',
            elem: 'popup',
            content: cities.map(function (city, index) {
                var isChecked = selectedCities.indexOf(city.geo_id) > -1;

                return {
                    block: 'search-filter',
                    elem: 'popup-item',
                    content: {
                        block: 'checkbox',
                        mods: { size: 's', checked: isChecked ? 'yes' : false, theme: 'normal' },
                        checkboxAttrs: { id: 'search-filter-city_' + index, value: city.geo_id },
                        text: city.name
                    }
                };
            })
        });
    },

    /**
     * Получить все выбранные пункты
     * @returns {Object}
     */
    getData: function () {
        return {
            countries: this._getSelectedCountries(),
            cities: this._getSelectedCities(),
            services: this._getSelectedServices()
        };
    },

    /**
     * Меняет URL при фильтрации
     * @param {Object} filters
     * @private
     */
    _changeUrl: function (filters) {
        var param = $.param(filters);
        var url = this.params.searchUrl + (param ? '?' + param : '');

        BEM.blocks['i-bem'].changeCurrentUrl(url);
    }
});
