module.exports = function (blocks) {
    blocks.declare('search-filter', function (data) {
        var agencySearch = data.agencySearch;
        var agenciesInfo = data.agenciesInfo;
        var filters = agenciesInfo.customFilters;

        if (!agencySearch.citiesByCountries) {
            return '';
        }

        return {
            block: 'search-filter',
            agencySearch: agencySearch,
            filters: filters,
            js: {
                citiesByCountries: agencySearch.citiesByCountries,
                services: agencySearch.services,
                agenciesFilters: agenciesInfo.filters,
                searchUrl: data.searchUrl,
                filterUrl: data.filterUrl,
                more: agenciesInfo.more,
                permutation: agenciesInfo.permutation,
                agenciesCount: agenciesInfo.list.length,
                filters: filters,
                ajax: true
            }
        };
    });
};
