module.exports = function (bh) {

    /**
     * Возвращает ссылку для фильтрации по категории
     * @param {String} text
     * @param {String} constraintId
     * @returns {String}
     */
    function buildCategoryUrl(text, constraintId) {
        var searchUrl = bh.lib.global.siteSearchUrl;

        text = encodeURIComponent(text);

        if (typeof constraintId === 'number') {
            return bh.lib.util.placeholder('{s}&text={s}&constraintid={s}',
                searchUrl, text, constraintId);
        }

        return bh.lib.util.placeholder('{s}&text={s}', searchUrl, text);
    }

    bh.match('search-result', function (ctx, json) {
        var found = bh.lib.i18n('search', 'found');
        var title = found + ' &laquo;' + json.text + '&raquo;';
        var search = json.search;

        ctx
            .js({
                page: json.page,
                constraintId: json.constraintId
            })
            .content([
                {
                    elem: 'title',
                    tag: 'h1',
                    content: title
                },
                ctx.content(),
                search && {
                    elem: 'categories',
                    search: search,
                    text: json.text
                },
                {
                    elem: 'serp',
                    attrs: {
                        id: 'ya-site-results',
                        'data-bem': JSON.stringify({
                            htmlcss: '1.x',
                            updatehash: false
                        })
                    }
                }
            ], true);
    });

    bh.match('search-result__categories', function (ctx, json) {
        var search = json.search;

        ctx
            .tag('ul')
            .content([
                {
                    elem: 'category',
                    tag: 'li',
                    category: bh.lib.i18n('search', 'all.pages'),
                    text: json.text
                },
                search.categories.map(function (category, idx) {
                    var level = category.level;

                    /* 3 levels of nesting are supported
                       See https://yandex.ru/support/site/create-setup/settings.html
                    */
                    if (!level || level < 1 || level > 3) {
                        level = 1;
                    }

                    return category.text && {
                        elem: 'category',
                        tag: 'li',
                        mods: {
                            level: level
                        },
                        attrs: { 'data-constraintid': idx },
                        constraintId: idx,
                        category: category.text,
                        text: json.text
                    };
                })
            ]);
    });

    bh.match('search-result__category', function (ctx, json) {
        ctx
            .tag('li')
            .content({
                block: 'link',
                mods: { theme: 'black' },
                text: json.category,
                url: buildCategoryUrl(json.text, json.constraintId)
            });
    });
};
