BEM.DOM.decl('search-result', {
    onSetMod: {
        js: {
            inited: function () {
                this._initAttempts = 100;
                this._pageBindingAttemts = 30;
                this._categoriesElem = this.findElem('categories');

                this._initSerp();
                this._findCategories();
                this._markSelectedCategory();

                if (!this._$currentCategory) {
                    this.setMod(this._allCategoriesElem, 'selected', true);
                }

                this.bindTo(this.elem('name'), 'pointerclick', function () {
                    BEM.DOM.win.scrollTop(0);
                });
            }
        }
    },

    /**
     * Находит элемент, сбрасывающий фильтры
     * @private
     */
    _findCategories: function () {
        this._categories = this.elem('category');

        for (var idx = 0; idx < this._categories.length; idx += 1) {
            var $elem = $(this._categories[idx]);

            if (typeof $elem.data('constraintid') !== 'number') {
                this._allCategoriesElem = $elem;
            }
        }
    },

    /**
     * Инициализация поисковой выдачи.
     * За 100 попыток вытаемся вызвать функцию инициализации.
     * @private
     */
    _initSerp: function () {
        if (this._initAttempts <= 0) {
            console.error('Не получилось загрузить поисковую выдачу');

            return;
        }

        this._initAttempts -= 1;

        try {
            Ya.Site.Results.init();
            this._bindPages();
        } catch (e) {
            setTimeout(this._initSerp.bind(this), 100);
        }
    },

    /**
     * Находит элемент пагинации и назначает обрботчик нажатия
     * @returns {Object | null}
     * @private
     */
    _bindPages: function () {
        if (this._pageBindingAttemts <= 0) {
            return;
        }

        this._pageBindingAttemts -= 1;

        var pager = this.findBlockInside('b-pager');

        if (!pager) {
            return setTimeout(this._bindPages.bind(this), 100);
        }

        var $pages = pager.elem('page');

        this._cutEllipsis($pages);

        this.bindTo($pages, 'pointerclick', this._onPageChange.bind(this));
    },

    /**
     * Делает многоточия неактивными
     * @param {jQuery} $pages
     * @private
     */
    _cutEllipsis: function ($pages) {
        for (var idx = 0; idx < $pages.length; idx += 1) {
            var $page = $($pages[idx]);
            var content = parseInt($page.text(), 10);

            if (Number.isNaN(content)) {
                this.setMod($page, 'page', 'ellipsis');
            }
        }
    },

    /**
     * Находит и выделяет выбранную картегорию
     * @private
     * @returns {null}
     */
    _markSelectedCategory: function () {
        var constraintId = this.params.constraintId;

        if (!constraintId) {
            return this.setMod(this._allCategoriesElem, 'selected', true);
        }

        constraintId = parseInt(constraintId, 10);

        for (var idx = 0; idx < this._categories.length; idx += 1) {
            var $elem = $(this._categories[idx]);

            if (constraintId === $elem.data('constraintid')) {
                this._$currentCategory = $elem;

                this.setMod($elem, 'selected', true);
            }
        }
    },

    /**
     * Обработчик смены страницы
     * @param {Object} e
     * @private
     */
    _onPageChange: function (e) {
        e.preventDefault();

        var $target = e.data.domElem;
        var page = $target.text();
        var pageNumber = parseInt(page, 10);

        if (!Number.isNaN(pageNumber)) {
            this._changePage(pageNumber - 1);
        }
    },

    /**
     * Переключить страницу
     * @param {Number} page
     * @private
     */
    _changePage: function (page) {
        if (typeof page !== 'number' || page < 0) {
            return;
        }

        var href = window.location.href;
        var pageQuery = BH.lib.util.placeholder('p={s}', page);

        BEM.DOM.win.scrollTop(0);

        if (href.match(/p=\d+/)) {
            window.location = href.replace(/p=\d+/g, pageQuery);
        } else {
            window.location = BH.lib.util.placeholder('{s}&{s}', href, pageQuery);
        }
    }
});
