module.exports = function (bh) {

    /**
     * Возвращает BEM-JSON для инпута
     * @param {String} text
     * @param {String} placeholder
     * @returns {Object}
     */
    var getInput = function (text, placeholder) {
        return {
            block: 'input',
            mods: { theme: 'normal', size: 'm' },
            value: text,
            content: {
                elem: 'control',
                attrs: { placeholder: !text && placeholder }
            }
        };
    };

    bh.match('search', function (ctx, json) {
        var type = json.mods.type;

        ctx
            .tParam('text', json.text)
            .js({
                searchUrl: bh.lib.global.siteSearchUrl,
                type: type
            })
            .tag('form')
            .content([
                type === 'menu' && { elem: 'button' },
                {
                    elem: 'input',
                    mods: { hidden: 'yes', type: type }
                }
            ]);
    });

    bh.match('search__input_type_menu', function (ctx) {
        var input = getInput(ctx.tParam('text'));

        ctx.content(input);
    });

    bh.match('search__input_type_sidebar', function (ctx) {
        var placeholder = bh.lib.i18n('search', 'search');
        var input = getInput(ctx.tParam('text'), placeholder);

        ctx.content([{ elem: 'button' }, input, ctx.content()], true);
    });
};
