BEM.DOM.decl('search', {
    onSetMod: {
        js: function () {
            this._findElems();
            this._bindEvents();
        }
    },

    /**
     * Поиск и сохранение элементов
     * @private
     */
    _findElems: function () {
        var bPage = this.findBlockOutside('b-page');

        this._menu = bPage.findBlockInside('main-menu');
        this._inputElem = this.findElem('input');
        this._input = this.findBlockInside(this._inputElem, 'input');
        this._inputControl = this._input.findElem('control');
        this._button = this.findElem('button');

        if (this._input.val()) {
            this._hideButton();
        }
    },

    /**
     * Привязка событий
     * @private
     */
    _bindEvents: function () {
        this.bindToWin('pointerclick', this._winClick.bind(this));
        this.domElem.on('submit', this._onSubmit.bind(this));

        if (this.params.type === 'menu') {
            this.bindTo(this._button, 'pointerclick', this._showInput.bind(this));
        }
    },

    /**
     * Показать кнопку
     * @private
     */
    _showButton: function () {
        var inputValue = this._input.val();

        this.toggleMod(this._button, 'hidden', '', 'yes', inputValue.length === 0);
    },

    /**
     * Скрыть кнопку
     * @private
     */
    _hideButton: function () {
        this.setMod(this._button, 'hidden', 'yes');
    },

    /**
     * Показывает инпут
     * @private
     */
    _showInput: function () {
        this.bindToDoc('keydown', this._onKeyDown.bind(this));
        this._menu.trigger('search-input-show');
        this.delMod(this._inputElem, 'hidden');
        this._inputControl.focus();
    },

    /**
     * Скрывает инпут
     * @private
     */
    _hideInput: function () {
        this.unbindFromDoc('keydown');
        this._menu.trigger('search-input-hide');
        this.setMod(this._inputElem, 'hidden', 'yes');
    },

    /**
     * Обработчик нажатия клавиши при активном инпуте
     * @param {Object} e
     * @private
     */
    _onKeyDown: function (e) {
        var keycodes = BEM.blocks.keycodes;

        if (e.keyCode === keycodes.ESC) {
            this._hideInput();
        }
    },

    /**
     * Обработчик отправки формы
     * @param {Object} e
     * @private
     */
    _onSubmit: function (e) {
        e.preventDefault();

        var inputValue = this._input.val();

        if (inputValue.length) {
            var encodedValue = encodeURIComponent(inputValue);

            window.location = this.params.searchUrl + '&text=' + encodedValue;
        }
    },

    /**
     * Обработчик клика по любой области экрана
     * @param {Object} e
     * @private
     */
    _winClick: function (e) {
        if (e.target === this._button[0]) {
            this._showInput();
        } else if (e.target !== this._inputControl[0]) {
            this._hideInput();
        }
    }
});
