module.exports = function (bh) {
    bh.match('section', function (ctx, json) {
        var data = json.data;
        var title = data.title;
        var paragraphs = data.paragraphs;

        ctx.content([
            title && {
                elem: 'title',
                tag: 'h2',
                content: title
            },
            paragraphs && paragraphs.length ? paragraphs.map(function (paragraph) {
                return {
                    elem: 'paragraph',
                    mods: paragraph.isLarge && { text: 'large' },
                    mix: { block: 'html-content' },
                    tag: 'p',
                    content: paragraph.text
                };
            }) : null
        ]);
    });
};
