module.exports = function (bh) {
    function hasCta(data) {
        return data && data.cta && data.cta.title && data.cta.url && data.cta.buttonText;
    }

    function hasValues(values) {
        return values && values.length ? values.some(function (value) {
            return value.top || value.bottom;
        }) : null;
    }

    function translateKeywords(keywords, dictionaryArr) {
        if (!keywords || !dictionaryArr) {
            return [];
        }

        keywords = keywords.split(',') || [];
        var dictionary = dictionaryArr.reduce(function(acc, translate) {
            acc[translate.slug] = translate.name;

            return acc;
        }, {});

        return keywords.map( function(word) {
            return dictionary[word] || word;
        });
    }

    /* eslint-disable complexity */
    bh.match('solution-info', function (ctx, json) {
        var solution = json.solution;
        var solutionSection = json.solutionSection || {};
        var isDatesHidden = solutionSection.isDatesHidden;
        var solutionDate = solution.date && bh.lib.util.getDate(solution.date);
        var date = solutionDate && bh.lib.util.date.humanizeDate(solutionDate, 'full');
        var theme = solution.theme;
        var section = solution.section;
        var isCase = section === 'cases';
        var values = !isCase && solution.company && [
            solution.company.col1,
            solution.company.col2,
            solution.company.col3
        ];

        var keywords = []
            .concat(
                translateKeywords(solution.tasks, solutionSection.tasks),
                translateKeywords(solution.industries, solutionSection.industries),
                translateKeywords(solution.products, solutionSection.products),
                translateKeywords(solution.companySize, solutionSection.companySize)
            )
            .filter( function(str) {
                return str && str.length > 0;
            })
            .join(',');

        ctx
            .js({ section: section })
            .attrs({
                itemscope: true,
                itemtype: 'http://schema.org/Article'
            })
            .content([
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'identifier',
                        content: solution.slug
                    }
                },
                {
                    tag: 'meta',
                    attrs: {
                        itemprop: 'keywords',
                        content: keywords
                    }
                },
                solution.title && {
                    tag: 'h1',
                    elem: 'title',
                    content: solution.title,
                    attrs: {
                        itemprop: 'headline'
                    }
                },
                isCase && theme ? {
                    tag: 'h2',
                    elem: 'theme',
                    content: theme,
                    attrs: {
                        itemprop: 'about'
                    }
                } : date && !isDatesHidden && {
                    tag: 'p',
                    elem: 'date',
                    content: date
                },
                {
                    elem: 'image',
                    solution: solution
                },
                {
                    elem: 'info',
                    description: solution.description,
                    info: solution.info,
                    copyright: solution.footer.copyright,
                    solutionDate: solutionDate,
                    date: isCase && theme && date
                },
                hasValues(values) && {
                    elem: 'values',
                    values: values
                },
                solution.content && solution.content.length ? {
                    elem: 'blocks',
                    blocks: solution.content,
                    solutions: json.solutions,
                    solutionsUrl: json.solutionsUrl
                } : null,
                {
                    elem: 'footer',
                    solution: solution
                }
            ]);
    });
    /* eslint-enable complexity */

    bh.match('solution-info__image', function (ctx, json) {
        var solution = json.solution;

        if (!solution.image || solution.notShowImage) {
            return '';
        }

        ctx
            .tag('img')
            .attrs({
                alt: solution.title,
                title: solution.title
            });
    });

    /* eslint-disable complexity */
    bh.match('solution-info__info', function (ctx, json) {
        var description = json.description;
        var info = json.info;
        var copyright = json.copyright;
        var date = json.date;
        var solutionDate = json.solutionDate;

        var content = [
            description && {
                elem: 'info-text',
                mix: { block: 'html-content' },
                content: description,
                attrs: {
                    itemprop: 'description'
                }
            },
            {
                elem: 'info-brief',
                info: info
            }
        ];

        if (!description && !info.city && !info.site) {
            return '';
        }

        ctx.content([
            bh.lib.global.isMobile ? content : content.reverse(),
            (copyright || date) && {
                elem: 'row',
                content: [
                    copyright && {
                        elem: 'copyright',
                        mix: { block: 'html-content' },
                        content: copyright
                    },
                    date && {
                        tag: 'time',
                        elem: 'date',
                        content: date,
                        attrs: {
                            datetime: solutionDate,
                            itemprop: 'dateModified'
                        }
                    }
                ]
            }
        ]);
    });
    /* eslint-enable complexity */

    bh.match('solution-info__info-brief', function (ctx, json) {
        var info = json.info;

        if (!info || !info.length) {
            return '';
        }

        ctx.content(info.map(function (item) {
            var url = item.url;
            var value = item.value;

            return {
                elem: 'info-row',
                content: [
                    {
                        elem: 'info-row-property',
                        content: item.label + ':'
                    },
                    {
                        elem: 'info-row-value',
                        content: url ? {
                            block: 'link',
                            mods: { theme: 'normal' },
                            content: value,
                            url: 'http://' + url
                        } : value
                    }
                ]
            };
        }));
    });

    bh.match('solution-info__blocks', function (ctx, json) {
        var blocks = json.blocks;

        ctx
            .attrs({
                itemprop: 'articleBody'
            })
            .content(blocks.map(function (block) {
                return {
                    block: 'solution-page-block',
                    properties: block,
                    solutions: json.solutions,
                    solutionsUrl: json.solutionsUrl
                };
            }));
    });

    bh.match('solution-info__values', function (ctx, json) {
        var values = json.values;

        ctx.content(values.map(function (item) {
            var hasValue = Boolean(item && (item.top || item.bottom));

            return {
                block: 'solution-value',
                mods: { empty: !hasValue },
                value: item.top,
                description: item.bottom
            };
        }));
    });

    /* eslint-disable complexity */
    bh.match('solution-info__footer', function (ctx, json) {
        var solution = json.solution;
        var footer = solution.footer;
        var button = footer.button;
        var hasCtaBlock = hasCta(footer);

        if (!footer.text && !button.url && !footer.og && !hasCtaBlock) {
            return '';
        }

        ctx.content([
            {
                elem: 'footer-row',
                solution: solution
            },
            hasCtaBlock && {
                elem: 'cta',
                content: {
                    block: 'product-cta-3',
                    data: {
                        title: footer.cta.title,
                        text: footer.cta.description,
                        metrikaGoalId: footer.cta.metrikaGoalId,
                        cta: {
                            text: footer.cta.buttonText,
                            url: footer.cta.url
                        }
                    }
                }
            }
        ]);
    });
    /* eslint-enable complexity */
};
